/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.toggleswitch;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.toggleswitch.ToggleSwitch;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class ToggleSwitchRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        ToggleSwitch toggleSwitch = (ToggleSwitch)component;
        if (!this.shouldDecode(toggleSwitch)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)toggleSwitch);
        String clientId = toggleSwitch.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        boolean checked = this.isChecked(submittedValue);
        toggleSwitch.setSubmittedValue(checked);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ToggleSwitch toggleSwitch = (ToggleSwitch)component;
        this.encodeMarkup(context, toggleSwitch);
        this.encodeScript(context, toggleSwitch);
    }

    protected void encodeMarkup(FacesContext context, ToggleSwitch toggleSwitch) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = toggleSwitch.getClientId(context);
        boolean checked = Boolean.parseBoolean(ComponentUtils.getValueToRender(context, (UIComponent)toggleSwitch));
        boolean disabled = toggleSwitch.isDisabled();
        String style = toggleSwitch.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-toggleswitch ui-widget").add(toggleSwitch.getStyleClass()).add(checked, "ui-toggleswitch-checked").add(disabled, "ui-state-disabled").add(toggleSwitch.getOffIcon() != null, "ui-toggleswitch-dual-icon").build();
        writer.startElement("div", (UIComponent)toggleSwitch);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, toggleSwitch, clientId, checked);
        this.encodeSlider(context, toggleSwitch, checked);
        writer.endElement("div");
    }

    protected void encodeSlider(FacesContext context, ToggleSwitch toggleSwitch, boolean checked) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-toggleswitch-slider").add(!toggleSwitch.isValid(), "ui-state-error").build();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-toggleswitch-handler", null);
        if (LangUtils.isNotEmpty(toggleSwitch.getOnIcon())) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)toggleSwitch.getOnIcon(), null);
            writer.endElement("span");
        }
        if (LangUtils.isNotEmpty(toggleSwitch.getOffIcon())) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)toggleSwitch.getOffIcon(), null);
            writer.endElement("span");
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, ToggleSwitch toggleSwitch, String clientId, boolean checked) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        String ariaLabel = toggleSwitch.getAriaLabel() != null ? toggleSwitch.getAriaLabel() : toggleSwitch.getLabel();
        writer.startElement("div", (UIComponent)toggleSwitch);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("aria-checked", (Object)checked, null);
        writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        this.renderValidationMetadata(context, (EditableValueHolder)toggleSwitch, new ClientValidator[0]);
        this.renderAccessibilityAttributes(context, toggleSwitch);
        this.renderPassThruAttributes(context, (UIComponent)toggleSwitch, HTML.TAB_INDEX);
        this.renderOnchange(context, (UIComponent)toggleSwitch);
        this.renderDomEvents(context, (UIComponent)toggleSwitch, HTML.BLUR_FOCUS_EVENTS);
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ToggleSwitch toggleSwitch) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ToggleSwitch", toggleSwitch).finish();
    }

    protected boolean isChecked(String value) {
        return value != null && ("on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value));
    }

    @Override
    public String getHighlighter() {
        return "toggleswitch";
    }
}

