/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.export;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.export.ColumnValue;
import org.primefaces.component.export.ExcelOptions;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.export.TreeTableExporter;
import org.primefaces.util.ExcelStylesManager;
import org.primefaces.util.LocaleUtils;

public class TreeTableExcelExporter
extends TreeTableExporter<Workbook, ExcelOptions> {
    private ExcelStylesManager stylesManager;

    public TreeTableExcelExporter() {
        super(new ExcelOptions());
    }

    @Override
    protected void preExport(FacesContext context) throws IOException {
        super.preExport(context);
        this.stylesManager = ExcelStylesManager.createExcelStylesManager((Workbook)this.document, LocaleUtils.getCurrentLocale(context), (ExcelOptions)this.options());
    }

    @Override
    protected Workbook createDocument(FacesContext context) throws IOException {
        return new HSSFWorkbook();
    }

    @Override
    protected void exportTable(FacesContext context, TreeTable table, int index) throws IOException {
        Sheet sheet = this.createSheet(context, table, index);
        super.exportTable(context, table, index);
        this.autoSizeColumn(table, sheet);
    }

    @Override
    protected void preRowExport(FacesContext context, TreeTable table) {
        Sheet sheet = this.sheet();
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        sheet.createRow(sheetRowIndex);
    }

    @Override
    protected void postExport(FacesContext context) throws IOException {
        super.postExport(context);
        ((Workbook)this.document).write(this.os());
    }

    @Override
    protected void exportTabletFacetValue(FacesContext context, TreeTable table, String textValue) {
        Sheet sheet = this.sheet();
        int rowIndex = this.sheet().getLastRowNum();
        int colspan = this.getExportableColumns(table).size();
        if (colspan > 1) {
            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, colspan - 1));
        }
        this.exportColumnFacetValue(context, table, ColumnValue.of(textValue), 0);
    }

    @Override
    protected void exportColumnFacetValue(FacesContext context, TreeTable table, ColumnValue columnValue, int index) {
        Cell cell = this.row().createCell(index);
        this.stylesManager.updateFacetCell(cell, columnValue);
    }

    @Override
    protected void exportCellValue(FacesContext context, TreeTable table, UIColumn col, ColumnValue columnValue, int i) {
        Cell cell = this.row().createCell(i);
        this.stylesManager.updateCell(col, cell, columnValue);
    }

    @Override
    protected void exportColumnGroupFacetValue(FacesContext context, TreeTable table, UIColumn column, AtomicInteger colIndex, ColumnValue columnValue) {
        Sheet sheet = this.sheet();
        int rowIndex = sheet.getLastRowNum();
        int rowSpan = (column.getExportRowspan() != 0 ? column.getExportRowspan() : column.getRowspan()) - 1;
        int colSpan = (column.getExportColspan() != 0 ? column.getExportColspan() : column.getColspan()) - 1;
        if (rowSpan > 0 && colSpan > 0) {
            colIndex.set(this.calculateColumnOffset(sheet, rowIndex, colIndex.get()));
            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan, colIndex.get(), colIndex.get() + colSpan));
            this.exportColumnFacetValue(context, table, columnValue, (int)((short)colIndex.get()));
            colIndex.set(colIndex.get() + colSpan);
        } else if (rowSpan > 0) {
            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan, colIndex.get(), colIndex.get()));
            this.exportColumnFacetValue(context, table, columnValue, (int)((short)colIndex.get()));
        } else if (colSpan > 0) {
            colIndex.set(this.calculateColumnOffset(sheet, rowIndex, colIndex.get()));
            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex.get(), colIndex.get() + colSpan));
            this.exportColumnFacetValue(context, table, columnValue, (int)((short)colIndex.get()));
            colIndex.set(colIndex.get() + colSpan);
        } else {
            colIndex.set(this.calculateColumnOffset(sheet, rowIndex, colIndex.get()));
            this.exportColumnFacetValue(context, table, columnValue, (int)((short)colIndex.get()));
        }
    }

    @Override
    public String getContentType() {
        return "application/vnd.ms-excel";
    }

    @Override
    public String getFileExtension() {
        return ".xls";
    }

    protected void autoSizeColumn(TreeTable table, Sheet sheet) {
        ExcelOptions options = (ExcelOptions)this.exportConfiguration.getOptions();
        if (options == null || options.isAutoSizeColumn()) {
            for (int i = 0; i < this.getExportableColumns(table).size(); ++i) {
                sheet.autoSizeColumn(i);
            }
        }
    }

    protected int calculateColumnOffset(Sheet sheet, int row, int col) {
        for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
            CellRangeAddress merged = sheet.getMergedRegion(j);
            if (!merged.isInRange(row, col)) continue;
            col = merged.getLastColumn() + 1;
        }
        return col;
    }

    protected Sheet createSheet(FacesContext context, TreeTable table, int index) {
        String sheetName = this.getSheetName(context, (UIComponent)table, index);
        Sheet sheet = ((Workbook)this.document).createSheet(sheetName);
        this.applyOptions(sheet);
        return sheet;
    }

    protected void applyOptions(Sheet sheet) {
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        printSetup.setPaperSize((short)9);
        sheet.setPrintGridlines(true);
    }

    public String getSheetName(FacesContext context, UIComponent table, int index) {
        Object sheetName = this.getComponentFacetValue(context, table, "header");
        if (sheetName == null) {
            sheetName = table.getId() + (index + 1);
        }
        if ("empty".equals(sheetName = WorkbookUtil.createSafeSheetName((String)sheetName)) || "null".equals(sheetName)) {
            sheetName = "Sheet (" + (index + 1) + ")";
        }
        return sheetName;
    }

    protected Row row() {
        Sheet sheet = this.sheet();
        return sheet.getRow(sheet.getLastRowNum());
    }

    protected Sheet sheet() {
        if (((Workbook)this.document).getNumberOfSheets() == 0) {
            throw new IllegalStateException("No existing sheet");
        }
        return ((Workbook)this.document).getSheetAt(((Workbook)this.document).getNumberOfSheets() - 1);
    }
}

