/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.feature;

import jakarta.el.ELContext;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.primefaces.PrimeFaces;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.TreeTableRenderer;
import org.primefaces.component.treetable.TreeTableState;
import org.primefaces.component.treetable.feature.TreeTableFeature;
import org.primefaces.component.treetable.feature.TreeTableFeatures;
import org.primefaces.event.data.PostFilterEvent;
import org.primefaces.model.CheckboxTreeNode;
import org.primefaces.model.DefaultTreeNode;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.TreeNode;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.FunctionFilterConstraint;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LocaleUtils;

public class FilterFeature
implements TreeTableFeature {
    @Override
    public void decode(FacesContext context, TreeTable table) {
        Map<String, FilterMeta> filterBy = table.getFilterByAsMap();
        table.updateFilterByValuesWithFilterRequest(context, filterBy);
        table.updateFilteredValue(context, null);
        table.setValue(null);
        table.setFirst(0);
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        String rppValue = (String)params.get(clientId + "_rppDD");
        if (rppValue != null && !"*".equals(rppValue)) {
            table.setRows(Integer.parseInt(rppValue));
        }
        if (table.isMultiViewState()) {
            TreeTableState ts = table.getMultiViewState(true);
            ts.setFilterBy(filterBy);
            if (table.isPaginator()) {
                ts.setFirst(table.getFirst());
                ts.setRows(table.getRows());
            }
        }
    }

    @Override
    public void encode(FacesContext context, TreeTableRenderer renderer, TreeTable table) throws IOException {
        this.filter(context, table, table.getValue());
        if (table.isSortingCurrentlyActive()) {
            TreeTableFeatures.sortFeature().sort(context, table);
        }
        context.getApplication().publishEvent(context, PostFilterEvent.class, (Object)table);
        renderer.encodeTbody(context, table, table.getValue(), true);
    }

    public void filter(FacesContext context, TreeTable tt, TreeNode root) {
        Map<String, FilterMeta> filterBy = tt.getFilterByAsMap();
        if (filterBy.isEmpty()) {
            return;
        }
        Locale filterLocale = LocaleUtils.getCurrentLocale(context);
        List<String> filteredRowKeys = tt.getFilteredRowKeys();
        filteredRowKeys.clear();
        this.collectFilteredRowKeys(context, tt, root, root, filterBy, filterLocale, filteredRowKeys);
        TreeNode filteredValue = this.cloneTreeNode(root, root.getParent());
        this.createFilteredValueFromRowKeys(tt, root, filteredValue, filteredRowKeys);
        tt.updateFilteredValue(context, filteredValue);
        tt.setValue(filteredValue);
        tt.setRowKey(root, null);
        if (ComponentUtils.isRequestSource((UIComponent)tt, context)) {
            if (tt.isPaginator()) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", filteredValue.getChildCount());
            }
            if (tt.getSelectedRowKeysAsString() != null) {
                PrimeFaces.current().ajax().addCallbackParam("selection", tt.getSelectedRowKeysAsString());
            }
        }
    }

    protected void collectFilteredRowKeys(FacesContext context, TreeTable tt, TreeNode<?> root, TreeNode<?> node, Map<String, FilterMeta> filterBy, Locale filterLocale, List<String> filteredRowKeys) {
        ELContext elContext = context.getELContext();
        FilterMeta globalFilter = filterBy.get("globalFilter");
        boolean hasGlobalFilterFunction = globalFilter != null && globalFilter.getConstraint() instanceof FunctionFilterConstraint;
        int childCount = node.getChildCount();
        AtomicBoolean localMatch = new AtomicBoolean();
        AtomicBoolean globalMatch = new AtomicBoolean();
        for (int i = 0; i < childCount; ++i) {
            TreeNode<?> childNode = node.getChildren().get(i);
            String rowKey = childNode.getRowKey();
            tt.setRowKey(root, rowKey);
            localMatch.set(true);
            globalMatch.set(false);
            if (hasGlobalFilterFunction) {
                globalMatch.set(globalFilter.getConstraint().isMatching(context, childNode, globalFilter.getFilterValue(), filterLocale));
            }
            tt.forEachColumn(column -> {
                Object filterValue;
                FilterConstraint constraint;
                FilterMeta filter = (FilterMeta)filterBy.get(column.getColumnKey((UIComponent)tt, rowKey));
                if (filter == null || filter.isGlobalFilter()) {
                    return true;
                }
                Object columnValue = filter.getLocalValue(elContext, (UIColumn)column);
                if (globalFilter != null && globalFilter.isActive() && !globalMatch.get() && !hasGlobalFilterFunction) {
                    constraint = globalFilter.getConstraint();
                    filterValue = globalFilter.getFilterValue();
                    globalMatch.set(constraint.isMatching(context, columnValue, filterValue, filterLocale));
                }
                if (!filter.isActive()) {
                    return true;
                }
                constraint = filter.getConstraint();
                filterValue = filter.getFilterValue();
                localMatch.set(constraint.isMatching(context, columnValue, filterValue, filterLocale));
                return localMatch.get();
            });
            boolean matches = localMatch.get();
            if (globalFilter != null && globalFilter.isActive()) {
                boolean bl = matches = matches && globalMatch.get();
            }
            if (matches) {
                filteredRowKeys.add(rowKey);
            }
            this.collectFilteredRowKeys(context, tt, root, childNode, filterBy, filterLocale, filteredRowKeys);
        }
    }

    private void createFilteredValueFromRowKeys(TreeTable tt, TreeNode<?> node, TreeNode<?> filteredNode, List<String> filteredRowKeys) {
        int childCount = node.getChildCount();
        block0: for (int i = 0; i < childCount; ++i) {
            TreeNode<?> childNode = node.getChildren().get(i);
            String rowKeyOfChildNode = childNode.getRowKey();
            for (String rk : filteredRowKeys) {
                if (!rk.equals(rowKeyOfChildNode) && !rk.startsWith(rowKeyOfChildNode + "_") && !rowKeyOfChildNode.startsWith(rk + "_")) continue;
                TreeNode newNode = this.cloneTreeNode(childNode, filteredNode);
                if (rk.startsWith(rowKeyOfChildNode + "_")) {
                    newNode.setExpanded(true);
                }
                this.createFilteredValueFromRowKeys(tt, childNode, newNode, filteredRowKeys);
                continue block0;
            }
        }
    }

    protected TreeNode cloneTreeNode(TreeNode<?> node, TreeNode<?> parent) {
        TreeNode<?> clone = null;
        if (CheckboxTreeNode.class.equals(node.getClass())) {
            clone = new CheckboxTreeNode(node.getType(), node.getData(), parent);
        } else if (DefaultTreeNode.class.equals(node.getClass())) {
            clone = new DefaultTreeNode(node.getType(), node.getData(), parent);
        } else {
            block15: {
                Constructor<?> ctor;
                block14: {
                    if (node instanceof Cloneable) {
                        try {
                            Method cloneMethod = node.getClass().getMethod("clone", new Class[0]);
                            cloneMethod.setAccessible(true);
                            clone = (TreeNode)cloneMethod.invoke(node, new Object[0]);
                        }
                        catch (ReflectiveOperationException e) {
                            throw new FacesException("Cloning using " + node.getClass().getSimpleName() + "#clone() failed", (Throwable)e);
                        }
                    }
                    try {
                        ctor = node.getClass().getConstructor(node.getClass());
                        clone = (TreeNode)ctor.newInstance(node);
                        if (parent != null) {
                            parent.getChildren().add(clone);
                        }
                    }
                    catch (ReflectiveOperationException e) {
                        if (e instanceof NoSuchMethodException) break block14;
                        throw new FacesException("Calling copy constructor of " + node.getClass().getSimpleName() + " failed: " + e.getMessage());
                    }
                }
                if (clone == null) {
                    try {
                        ctor = node.getClass().getConstructor(String.class, Object.class, TreeNode.class);
                        clone = (TreeNode)ctor.newInstance(node.getType(), node.getData(), parent);
                    }
                    catch (ReflectiveOperationException e) {
                        if (e instanceof NoSuchMethodException) break block15;
                        throw new FacesException("Calling constructor " + node.getClass().getSimpleName() + "(String type, Object data, TreeNode parent) failed", (Throwable)e);
                    }
                }
            }
            if (clone == null) {
                throw new FacesException("Custom node requires to implement either Cloneable, a constructor: " + node.getClass().getSimpleName() + "(String type, Object data, TreeNode parent), or a copy contructor");
            }
        }
        clone.setSelectable(node.isSelectable());
        clone.setSelected(node.isSelected());
        clone.setExpanded(node.isExpanded());
        return clone;
    }

    @Override
    public boolean shouldDecode(FacesContext context, TreeTable table) {
        return context.getCurrentPhaseId() == PhaseId.PROCESS_VALIDATIONS && this.isFilterRequest(context, table);
    }

    @Override
    public boolean shouldEncode(FacesContext context, TreeTable table) {
        return this.isFilterRequest(context, table);
    }

    private boolean isFilterRequest(FacesContext context, TreeTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_filtering");
    }
}

