/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.config;

import jakarta.faces.context.FacesContext;
import jakarta.validation.Validation;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.util.LangUtils;

public class PrimeEnvironment {
    private static final Logger LOGGER = Logger.getLogger(PrimeEnvironment.class.getName());
    private final boolean beanValidationAvailable;
    private final boolean atLeastJsf40 = LangUtils.isClassAvailable("jakarta.faces.lifecycle.ClientWindowScoped");
    private final boolean mojarra;
    private final boolean atLeastBv11 = LangUtils.isClassAvailable("jakarta.validation.executable.ExecutableValidator");
    private final String buildVersion;
    private final boolean htmlSanitizerAvailable;

    public PrimeEnvironment(FacesContext context) {
        this.beanValidationAvailable = this.resolveBeanValidationAvailable();
        this.buildVersion = this.resolveBuildVersion();
        this.htmlSanitizerAvailable = LangUtils.isClassAvailable("org.owasp.html.PolicyFactory");
        this.mojarra = context == null || context.getExternalContext() == null ? false : context.getExternalContext().getApplicationMap().containsKey("com.sun.faces.ApplicationAssociate");
    }

    protected boolean resolveBeanValidationAvailable() {
        boolean beanValidationAvailable = LangUtils.isClassAvailable("jakarta.validation.Validation");
        if (beanValidationAvailable) {
            try {
                Validation.buildDefaultValidatorFactory().getValidator();
            }
            catch (Throwable t) {
                LOGGER.log(Level.FINE, "BV not available - Could not build default ValidatorFactory.");
                beanValidationAvailable = false;
            }
        }
        return beanValidationAvailable;
    }

    protected String resolveBuildVersion() {
        String buildVersion = null;
        try (InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.primefaces/primefaces/pom.properties");){
            Properties buildProperties = new Properties();
            buildProperties.load(is);
            buildVersion = buildProperties.getProperty("version");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PrimeFaces version not resolvable - Could not load pom.properties.");
        }
        if (LangUtils.isBlank(buildVersion)) {
            buildVersion = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
        }
        return buildVersion;
    }

    public boolean isBeanValidationAvailable() {
        return this.beanValidationAvailable;
    }

    public boolean isAtLeastJsf40() {
        return this.atLeastJsf40;
    }

    public boolean isMojarra() {
        return this.mojarra;
    }

    public boolean isAtLeastBv11() {
        return this.atLeastBv11;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public boolean isHtmlSanitizerAvailable() {
        return this.htmlSanitizerAvailable;
    }
}

