/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialResponseWriter;
import jakarta.faces.context.PartialViewContext;
import jakarta.faces.context.PartialViewContextWrapper;
import jakarta.faces.event.PhaseId;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeFacesContext;
import org.primefaces.context.PrimePartialResponseWriter;
import org.primefaces.csp.CspPartialResponseWriter;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.visit.ResetInputContextCallback;
import org.primefaces.visit.ResetInputVisitCallback;

public class PrimePartialViewContext
extends PartialViewContextWrapper {
    private PartialResponseWriter writer;

    public PrimePartialViewContext(PartialViewContext wrapped) {
        super(wrapped);
    }

    public void processPartial(PhaseId phaseId) {
        PrimeEnvironment environment;
        if (phaseId == PhaseId.RENDER_RESPONSE && !(environment = PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getEnvironment()).isAtLeastJsf40()) {
            this.resetValues(FacesContext.getCurrentInstance());
        }
        this.getWrapped().processPartial(phaseId);
    }

    public void setPartialRequest(boolean value) {
        this.getWrapped().setPartialRequest(value);
    }

    public PartialResponseWriter getPartialResponseWriter() {
        if (this.writer == null) {
            PartialResponseWriter parentWriter = this.getWrapped().getPartialResponseWriter();
            FacesContext context = FacesContext.getCurrentInstance();
            PrimeConfiguration config = PrimeApplicationContext.getCurrentInstance(context).getConfig();
            this.writer = config.isCsp() ? new CspPartialResponseWriter(parentWriter, context, PrimeFacesContext.getCspState(context)) : new PrimePartialResponseWriter(parentWriter);
        }
        return this.writer;
    }

    public boolean isAjaxRequest() {
        return this.getWrapped().isAjaxRequest() || FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey("jakarta.faces.partial.ajax");
    }

    public boolean isPartialRequest() {
        return this.getWrapped().isPartialRequest() || FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey("jakarta.faces.partial.execute");
    }

    private void resetValues(FacesContext context) {
        boolean resetValues;
        Object resetValuesObject = context.getExternalContext().getRequestParameterMap().get("jakarta.faces.partial.resetValues");
        boolean bl = resetValues = null != resetValuesObject && "true".equals(resetValuesObject);
        if (resetValues) {
            VisitContext visitContext = null;
            ResetInputContextCallback contextCallback = null;
            for (String renderId : context.getPartialViewContext().getRenderIds()) {
                String id = LangUtils.defaultIfBlank(renderId, "").trim();
                if (LangUtils.isBlank(id) || "@none".equals(id)) continue;
                if (visitContext == null) {
                    visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
                }
                if ("@all".equals(id)) {
                    context.getViewRoot().visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
                    continue;
                }
                if (contextCallback == null) {
                    contextCallback = new ResetInputContextCallback(visitContext);
                }
                context.getViewRoot().invokeOnComponent(context, id, (ContextCallback)contextCallback);
            }
        }
    }
}

