/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.csp;

import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.primefaces.csp.CspException;
import org.primefaces.util.LangUtils;

public class CspState {
    private FacesContext context;
    private Map<String, Map<String, String>> eventHandlers;
    private String nonce;
    private boolean initialized = false;

    public CspState(FacesContext context) {
        this.context = context;
        this.eventHandlers = new HashMap<String, Map<String, String>>(10);
    }

    public String getNonce() {
        if (this.nonce == null) {
            if (this.context.isPostback() || this.context.getPartialViewContext().isAjaxRequest()) {
                String nonceRequest = (String)this.context.getExternalContext().getRequestParameterMap().get("primefaces.nonce");
                nonceRequest = Objects.toString(nonceRequest, "");
                String nonceViewState = "";
                Map viewMap = this.context.getViewRoot().getViewMap(false);
                if (viewMap != null) {
                    nonceViewState = Objects.toString(viewMap.get("primefaces.nonce"), "");
                    if (this.context.isPostback() && LangUtils.isNotBlank(nonceViewState) && !Objects.equals(nonceViewState, nonceRequest)) {
                        throw new CspException("CSP nonce mismatch");
                    }
                }
                String string = this.nonce = LangUtils.isNotBlank(nonceViewState) ? nonceViewState : nonceRequest;
                if (LangUtils.isBlank(this.nonce) && this.isForward(this.context)) {
                    this.nonce = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
                }
                this.validate(this.nonce);
            } else {
                this.nonce = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
                if (!this.context.getViewRoot().isTransient()) {
                    this.context.getViewRoot().getViewMap(true).put("primefaces.nonce", this.nonce);
                }
            }
        }
        return this.nonce;
    }

    protected boolean isForward(FacesContext context) {
        Object request = context.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getAttribute("jakarta.servlet.forward.request_uri") != null;
        }
        return false;
    }

    private void validate(String nonce) throws CspException {
        if (LangUtils.isEmpty(nonce)) {
            throw new CspException("Missing CSP nonce");
        }
        try {
            String decodedNonce = new String(Base64.getDecoder().decode(nonce), StandardCharsets.UTF_8);
            UUID.fromString(decodedNonce);
        }
        catch (Exception e) {
            throw new CspException("Invalid CSP nonce", e);
        }
    }

    public Map<String, Map<String, String>> getEventHandlers() {
        return this.eventHandlers;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

