/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.el;

import jakarta.el.ELContext;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueExpression;
import jakarta.el.ValueReference;
import jakarta.faces.el.CompositeComponentExpressionHolder;
import org.primefaces.el.InterceptingContext;
import org.primefaces.el.InterceptingResolver;

public class ValueExpressionAnalyzer {
    private ValueExpressionAnalyzer() {
    }

    public static ValueReference getReference(ELContext elContext, ValueExpression expression) {
        return ValueExpressionAnalyzer.getReference(elContext, expression, false);
    }

    public static ValueReference getReference(ELContext elContext, ValueExpression expression, boolean returnNullWhenUnresolvable) {
        if (expression == null) {
            return null;
        }
        try {
            ValueReference reference = ValueExpressionAnalyzer.toValueReference(expression, elContext);
            if (reference != null && ValueExpressionAnalyzer.isCompositeComponentReference(reference)) {
                ValueExpression unwrapped = ValueExpressionAnalyzer.unwrapCompositeComponentReference(reference);
                if (unwrapped != null) {
                    ValueReference unwrappedRef = ValueExpressionAnalyzer.toValueReference(unwrapped, elContext);
                    if (ValueExpressionAnalyzer.isCompositeComponentReference(unwrappedRef)) {
                        return ValueExpressionAnalyzer.getReference(elContext, unwrapped);
                    }
                    return unwrappedRef;
                }
                return null;
            }
            return reference;
        }
        catch (PropertyNotFoundException e) {
            if (returnNullWhenUnresolvable) {
                return null;
            }
            throw e;
        }
    }

    public static ValueExpression getExpression(ELContext elContext, ValueExpression expression) {
        return ValueExpressionAnalyzer.getExpression(elContext, expression, false);
    }

    public static ValueExpression getExpression(ELContext elContext, ValueExpression expression, boolean returnNullWhenUnresolvable) {
        if (expression == null) {
            return null;
        }
        try {
            ValueReference reference = ValueExpressionAnalyzer.toValueReference(expression, elContext);
            if (reference != null && ValueExpressionAnalyzer.isCompositeComponentReference(reference)) {
                ValueExpression unwrapped = ValueExpressionAnalyzer.unwrapCompositeComponentReference(reference);
                if (unwrapped != null && ValueExpressionAnalyzer.isCompositeComponentReference(ValueExpressionAnalyzer.toValueReference(unwrapped, elContext))) {
                    return ValueExpressionAnalyzer.getExpression(elContext, unwrapped);
                }
                return unwrapped;
            }
            return expression;
        }
        catch (PropertyNotFoundException e) {
            if (returnNullWhenUnresolvable) {
                return null;
            }
            throw e;
        }
    }

    public static boolean isCompositeComponentReference(ValueReference vr) {
        return vr != null && vr.getBase() != null && vr.getBase() instanceof CompositeComponentExpressionHolder;
    }

    public static ValueExpression unwrapCompositeComponentReference(ValueReference vr) {
        return ((CompositeComponentExpressionHolder)vr.getBase()).getExpression((String)vr.getProperty());
    }

    public static ValueReference intercept(ELContext elContext, ValueExpression expression) {
        if (expression == null) {
            return null;
        }
        InterceptingResolver resolver = new InterceptingResolver(elContext.getELResolver());
        InterceptingContext interceptingContext = new InterceptingContext(elContext, resolver);
        expression.getType((ELContext)interceptingContext);
        expression.getValue((ELContext)interceptingContext);
        return resolver.getValueReference();
    }

    public static ValueReference toValueReference(ValueExpression ve, ELContext elContext) {
        ValueReference reference = ve.getValueReference(elContext);
        if (reference == null) {
            reference = ValueExpressionAnalyzer.intercept(elContext, ve);
        }
        return reference;
    }
}

