/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIData;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchKeywordContext;
import jakarta.faces.component.search.SearchKeywordResolver;
import jakarta.faces.context.FacesContext;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.columns.Columns;

public class RowSearchKeywordResolver
extends SearchKeywordResolver {
    private static final Pattern PATTERN = Pattern.compile("row\\((\\d+)\\)");

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return keyword != null && keyword.startsWith("row(");
    }

    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }

    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(SearchKeywordContext expressionContext, UIComponent current, String keyword) {
        FacesContext facesContext = expressionContext.getSearchExpressionContext().getFacesContext();
        int row = this.validate(facesContext, expressionContext.getSearchExpressionContext().getSource(), current, keyword);
        UIData data = (UIData)current;
        int rowIndex = data.getRowIndex();
        try {
            data.setRowIndex(row);
            if (!data.isRowAvailable()) {
                return;
            }
            for (UIComponent column : data.getChildren()) {
                if (column instanceof Columns) {
                    List<DynamicColumn> dynamicColumns = ((Columns)column).getDynamicColumns();
                    for (int i = 0; i < dynamicColumns.size(); ++i) {
                        for (UIComponent comp : column.getChildren()) {
                            expressionContext.invokeContextCallback(comp);
                        }
                    }
                    continue;
                }
                if (!(column instanceof UIColumn)) continue;
                for (UIComponent cell : column.getChildren()) {
                    expressionContext.invokeContextCallback(cell);
                }
            }
        }
        finally {
            data.setRowIndex(rowIndex);
        }
    }

    protected int validate(FacesContext context, UIComponent source, UIComponent current, String keyword) {
        if (!(current instanceof UIData)) {
            throw new FacesException("The last resolved component must be instance of UIData to support @row. Expression: \"" + keyword + "\" referenced from \"" + current.getClientId(context) + "\".");
        }
        try {
            Matcher matcher = PATTERN.matcher(keyword);
            if (matcher.matches()) {
                int row = Integer.parseInt(matcher.group(1));
                if (row < 0) {
                    throw new FacesException("Row number must be greater than 0. Expression: \"" + keyword + "\"");
                }
                UIData data = (UIData)current;
                if (data.getRowCount() < row + 1) {
                    throw new FacesException("The row count of the target is lesser than the row number. Expression: \"" + keyword + "\"");
                }
                return row;
            }
            throw new FacesException("Expression does not match following pattern @row(n). Expression: \"" + keyword + "\"");
        }
        catch (Exception e) {
            throw new FacesException("Expression does not match following pattern @row(n). Expression: \"" + keyword + "\"", (Throwable)e);
        }
    }
}

