/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHint;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.primefaces.component.api.Widget;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.LangUtils;

public class SearchExpressionUtils {
    public static final Set<SearchExpressionHint> HINTS_IGNORE_NO_RESULT = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.IGNORE_NO_RESULT));
    public static final Set<SearchExpressionHint> HINTS_RESOLVE_CLIENT_SIDE = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.RESOLVE_CLIENT_SIDE));
    public static final Set<SearchExpressionHint> HINTS_IGNORE_NO_RESULT_RESOLVE_CLIENT_SIDE = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.RESOLVE_CLIENT_SIDE, SearchExpressionHint.IGNORE_NO_RESULT));

    private SearchExpressionUtils() {
    }

    public static Set<SearchExpressionHint> hintsIgnoreNoResult() {
        return EnumSet.of(SearchExpressionHint.IGNORE_NO_RESULT);
    }

    public static Set<SearchExpressionHint> hintsIgnoreNoResultResolveClientSide() {
        return EnumSet.of(SearchExpressionHint.IGNORE_NO_RESULT, SearchExpressionHint.RESOLVE_CLIENT_SIDE);
    }

    public static Set<SearchExpressionHint> hintsResolveClientSide() {
        return EnumSet.of(SearchExpressionHint.RESOLVE_CLIENT_SIDE);
    }

    public static UIComponent contextlessOptionalResolveComponent(FacesContext context, UIComponent component, String expression) {
        return SearchExpressionUtils.contextlessResolveComponent(context, component, expression, SearchExpressionUtils.hintsIgnoreNoResult());
    }

    public static UIComponent contextlessResolveComponent(FacesContext context, UIComponent component, String expression) {
        return SearchExpressionUtils.contextlessResolveComponent(context, component, expression, EnumSet.noneOf(SearchExpressionHint.class));
    }

    public static UIComponent contextlessResolveComponent(FacesContext context, UIComponent component, String expression, Set<SearchExpressionHint> hints) {
        if (LangUtils.isBlank(expression)) {
            return null;
        }
        AtomicReference result = new AtomicReference();
        context.getApplication().getSearchExpressionHandler().resolveComponent(SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)component, hints, null), expression, (ctx, target) -> result.set(target));
        return (UIComponent)result.get();
    }

    public static List<UIComponent> contextlessResolveComponents(FacesContext context, UIComponent component, String expression) {
        return SearchExpressionUtils.contextlessResolveComponents(context, component, expression, EnumSet.noneOf(SearchExpressionHint.class));
    }

    public static List<UIComponent> contextlessResolveComponents(FacesContext context, UIComponent component, String expression, Set<SearchExpressionHint> hints) {
        if (LangUtils.isBlank(expression)) {
            return null;
        }
        ArrayList<UIComponent> result = new ArrayList<UIComponent>();
        context.getApplication().getSearchExpressionHandler().resolveComponents(SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)component, hints, null), expression, (ctx, target) -> result.add(target));
        return result;
    }

    public static String resolveClientIdsAsString(FacesContext context, UIComponent component, String expression) {
        return SearchExpressionUtils.resolveClientIdsAsString(context, component, expression, null, null);
    }

    public static String resolveClientIdsAsString(FacesContext context, UIComponent component, String expression, Set<SearchExpressionHint> hints, Set<VisitHint> visitHints) {
        if (LangUtils.isBlank(expression)) {
            return null;
        }
        List clientIds = context.getApplication().getSearchExpressionHandler().resolveClientIds(SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)component, hints, visitHints), expression);
        return String.join((CharSequence)",", clientIds);
    }

    public static String resolveClientIdsForClientSide(FacesContext context, UIComponent component, String expression) {
        return SearchExpressionUtils.resolveClientIdsAsString(context, component, expression, HINTS_RESOLVE_CLIENT_SIDE, null);
    }

    public static String resolveOptionalClientIdsForClientSide(FacesContext context, UIComponent component, String expression) {
        return SearchExpressionUtils.resolveClientIdsAsString(context, component, expression, HINTS_IGNORE_NO_RESULT_RESOLVE_CLIENT_SIDE, null);
    }

    public static String resolveClientId(FacesContext context, UIComponent component, String expression) {
        if (LangUtils.isBlank(expression)) {
            return null;
        }
        return context.getApplication().getSearchExpressionHandler().resolveClientId(SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)component), expression);
    }

    public static String resolveOptionalClientIdForClientSide(FacesContext context, UIComponent component, String expression) {
        if (LangUtils.isBlank(expression)) {
            return null;
        }
        return context.getApplication().getSearchExpressionHandler().resolveClientId(SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)component, SearchExpressionUtils.hintsIgnoreNoResultResolveClientSide(), null), expression);
    }

    public static String resolveClientIdForClientSide(FacesContext context, UIComponent component, String expression) {
        if (LangUtils.isBlank(expression)) {
            return null;
        }
        return context.getApplication().getSearchExpressionHandler().resolveClientId(SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)component, SearchExpressionUtils.hintsResolveClientSide(), null), expression);
    }

    public static String resolveClientId(String expression, UIComponent source) {
        if (LangUtils.isBlank(expression)) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getSearchExpressionHandler().resolveClientId(SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)source), expression);
    }

    public static UIComponent resolveComponent(String expression, UIComponent source) {
        return SearchExpressionUtils.contextlessResolveComponent(FacesContext.getCurrentInstance(), source, expression);
    }

    public static String resolveClientIds(String expressions, UIComponent source) {
        return SearchExpressionUtils.resolveClientIdsAsString(FacesContext.getCurrentInstance(), source, expressions);
    }

    public static String resolveWidgetVar(String expression, UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent resolvedComponent = SearchExpressionUtils.contextlessResolveComponent(FacesContext.getCurrentInstance(), component, expression);
        if (resolvedComponent != null) {
            if (resolvedComponent instanceof Widget) {
                return ((Widget)resolvedComponent).resolveWidgetVar(context);
            }
            throw new FacesException("Component with clientId " + resolvedComponent.getClientId() + " is not a Widget");
        }
        return null;
    }

    public static String closestWidgetVar(UIComponent component) {
        Widget widget = ComponentTraversalUtils.closest(Widget.class, component, true);
        if (widget != null) {
            return widget.resolveWidgetVar(FacesContext.getCurrentInstance());
        }
        throw new FacesException("Component with clientId " + component.getClientId() + " has no Widget as parent");
    }
}

