/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchKeywordContext;
import jakarta.faces.component.search.SearchKeywordResolver;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.context.FacesContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.expression.WidgetVarVisitCallback;

public class WidgetVarSearchKeywordResolver
extends SearchKeywordResolver {
    private static final Pattern PATTERN = Pattern.compile("widgetVar\\(([\\w-_]+)\\)");

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return keyword != null && keyword.startsWith("widgetVar(");
    }

    public void resolve(SearchKeywordContext context, UIComponent current, String keyword) {
        block4: {
            try {
                Matcher matcher = PATTERN.matcher(keyword);
                if (matcher.matches()) {
                    WidgetVarVisitCallback visitCallback = new WidgetVarVisitCallback(matcher.group(1));
                    context.getSearchExpressionContext().getFacesContext().getViewRoot().visitTree(VisitContext.createVisitContext((FacesContext)context.getSearchExpressionContext().getFacesContext(), null, null), (VisitCallback)visitCallback);
                    if (visitCallback.getComponent() != null) {
                        context.invokeContextCallback(visitCallback.getComponent());
                    }
                    break block4;
                }
                throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + keyword + "\"");
            }
            catch (Exception e) {
                throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + keyword + "\"", (Throwable)e);
            }
        }
    }
}

