/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.Objects;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.ColumnBase;
import org.primefaces.component.headerrow.HeaderRow;
import org.primefaces.component.headerrow.HeaderRowBase;
import org.primefaces.model.SortOrder;
import org.primefaces.util.LangUtils;

public class SortMeta
implements Serializable,
Comparable<SortMeta> {
    public static final Integer MIN_PRIORITY = Integer.MAX_VALUE;
    public static final Integer MAX_PRIORITY = Integer.MIN_VALUE;
    private static final long serialVersionUID = 1L;
    private String columnKey;
    private String field;
    private SortOrder order = SortOrder.UNSORTED;
    private ValueExpression sortBy;
    private MethodExpression function;
    private int priority = MIN_PRIORITY;
    private int nullSortOrder;
    private boolean caseSensitiveSort;
    private boolean headerRow;
    private boolean dynamic;

    public SortMeta() {
    }

    SortMeta(String columnKey, String sortField, SortOrder sortOrder, MethodExpression sortFunction, ValueExpression sortBy, int priority, int nullSortOrder, boolean caseSensitiveSort, boolean headerRow, boolean dynamic) {
        this.columnKey = columnKey;
        this.field = sortField;
        this.order = sortOrder;
        this.function = sortFunction;
        this.sortBy = sortBy;
        this.priority = priority;
        this.nullSortOrder = nullSortOrder;
        this.caseSensitiveSort = caseSensitiveSort;
        this.headerRow = headerRow;
        this.dynamic = dynamic;
    }

    public static SortMeta of(FacesContext context, String var, UIColumn column) {
        boolean dynamic = column instanceof DynamicColumn;
        if (dynamic) {
            ((DynamicColumn)column).applyStatelessModel();
        }
        if (!column.isSortable()) {
            return null;
        }
        String field = column.getField();
        ValueExpression sortByVE = column.getValueExpression(ColumnBase.PropertyKeys.sortBy.name());
        if (field == null && sortByVE == null) {
            return null;
        }
        if (field == null) {
            field = column.resolveField(context, sortByVE);
        } else if (sortByVE == null) {
            sortByVE = UIColumn.createValueExpressionFromField(context, var, field);
        }
        SortOrder order = SortOrder.of(column.getSortOrder());
        if (order.isUnsorted() && column.isGroupRow()) {
            order = SortOrder.ASCENDING;
        }
        return new SortMeta(column.getColumnKey(), field, order, column.getSortFunction(), sortByVE, column.getSortPriority(), column.getNullSortOrder(), column.isCaseSensitiveSort(), false, dynamic);
    }

    public static SortMeta of(FacesContext context, String var, HeaderRow headerRow) {
        SortOrder order = SortOrder.of(headerRow.getSortOrder());
        ValueExpression groupByVE = headerRow.getValueExpression(HeaderRowBase.PropertyKeys.groupBy.name());
        if (groupByVE == null && LangUtils.isBlank(headerRow.getField())) {
            throw new FacesException("HeaderRow must have 'groupBy' or 'field' attribute value");
        }
        groupByVE = groupByVE != null ? groupByVE : UIColumn.createValueExpressionFromField(context, var, headerRow.getField());
        return new SortMeta(headerRow.getClientId(context), headerRow.getField(), order, headerRow.getSortFunction(), groupByVE, MAX_PRIORITY, SortOrder.ASCENDING.intValue(), false, true, false);
    }

    @Override
    public int compareTo(SortMeta o) {
        int result = Integer.compare(this.getPriority(), o.priority);
        if (result == 0) {
            return -1 * Boolean.compare(this.isActive(), o.isActive());
        }
        return result;
    }

    public String getField() {
        return this.field;
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public MethodExpression getFunction() {
        return this.function;
    }

    public void setFunction(MethodExpression function) {
        this.function = function;
    }

    public ValueExpression getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(ValueExpression sortBy) {
        this.sortBy = sortBy;
    }

    public boolean isActive() {
        return this.order != SortOrder.UNSORTED;
    }

    public void setOrder(SortOrder order) {
        this.order = order;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isHeaderRow() {
        return this.headerRow;
    }

    public String getColumnKey() {
        return this.columnKey;
    }

    public int getNullSortOrder() {
        return this.nullSortOrder;
    }

    public boolean isCaseSensitiveSort() {
        return this.caseSensitiveSort;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortMeta sortMeta = (SortMeta)o;
        return Objects.equals(this.columnKey, sortMeta.columnKey) && Objects.equals(this.field, sortMeta.field);
    }

    public int hashCode() {
        return Objects.hash(this.columnKey, this.field);
    }

    public String toString() {
        return "SortMeta{columnKey='" + this.columnKey + "', sortField='" + this.field + "', sortOrder=" + String.valueOf((Object)this.order) + ", sortBy=" + String.valueOf(this.sortBy) + ", sortFunction=" + String.valueOf(this.function) + ", priority=" + this.priority + ", nullSortOrder=" + this.nullSortOrder + ", caseSensitiveSort=" + this.caseSensitiveSort + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SortMeta sortBy = new SortMeta();

        private Builder() {
        }

        public Builder field(String field) {
            this.sortBy.field = field;
            return this;
        }

        public Builder order(SortOrder sortOrder) {
            this.sortBy.order = sortOrder;
            return this;
        }

        public Builder sortBy(ValueExpression sortBy) {
            this.sortBy.sortBy = sortBy;
            return this;
        }

        public Builder function(MethodExpression sortFunction) {
            this.sortBy.function = sortFunction;
            return this;
        }

        public Builder priority(int priority) {
            this.sortBy.priority = priority;
            return this;
        }

        public Builder nullSortOrder(int nullSortOrder) {
            this.sortBy.nullSortOrder = nullSortOrder;
            return this;
        }

        public Builder caseSensitiveSort(boolean caseSensitiveSort) {
            this.sortBy.caseSensitiveSort = caseSensitiveSort;
            return this;
        }

        public SortMeta build() {
            Objects.requireNonNull(this.sortBy.field, "Field is required");
            return this.sortBy;
        }
    }
}

