/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum SortOrder {
    ASCENDING(1, "asc", "1", "ascending", "ASCENDING", "ASC"),
    DESCENDING(-1, "desc", "-1", "descending", "DESCENDING", "DESC"),
    UNSORTED(0, "", null, "0", "unsorted", "UNSORTED");

    private final Set<Object> values;
    private final Integer intValue;

    private SortOrder(int intValue, Object ... values) {
        this.intValue = intValue;
        this.values = new HashSet<Object>(Arrays.asList(values));
    }

    public static SortOrder of(Object order) {
        for (SortOrder o : SortOrder.values()) {
            if (!o.intValue.equals(order) && !o.values.contains(order)) continue;
            return o;
        }
        throw new IllegalArgumentException("No SorderOrder matching value: " + String.valueOf(order));
    }

    public boolean isAscending() {
        return this == ASCENDING;
    }

    public boolean isDescending() {
        return this == DESCENDING;
    }

    public boolean isUnsorted() {
        return this == UNSORTED;
    }

    public int intValue() {
        return this.intValue;
    }
}

