/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.filter;

import jakarta.faces.FacesException;
import java.util.Map;
import java.util.Optional;
import org.primefaces.model.MatchMode;
import org.primefaces.model.filter.BetweenFilterConstraint;
import org.primefaces.model.filter.ContainsFilterConstraint;
import org.primefaces.model.filter.EndsWithFilterConstraint;
import org.primefaces.model.filter.EqualsFilterConstraint;
import org.primefaces.model.filter.ExactFilterConstraint;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.GlobalFilterConstraint;
import org.primefaces.model.filter.GreaterThanEqualsFilterConstraint;
import org.primefaces.model.filter.GreaterThanFilterConstraint;
import org.primefaces.model.filter.InFilterConstraint;
import org.primefaces.model.filter.LessThanEqualsFilterConstraint;
import org.primefaces.model.filter.LessThanFilterConstraint;
import org.primefaces.model.filter.NegationFilterConstraintWrapper;
import org.primefaces.model.filter.StartsWithFilterConstraint;
import org.primefaces.util.MapBuilder;

public final class FilterConstraints {
    private static final Map<MatchMode, FilterConstraint> ALL_CONSTRAINTS = MapBuilder.builder().put(MatchMode.STARTS_WITH, new StartsWithFilterConstraint()).put(MatchMode.NOT_STARTS_WITH, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new StartsWithFilterConstraint()))).put(MatchMode.ENDS_WITH, (StartsWithFilterConstraint)((Object)new EndsWithFilterConstraint())).put(MatchMode.NOT_ENDS_WITH, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new EndsWithFilterConstraint()))).put(MatchMode.CONTAINS, (StartsWithFilterConstraint)((Object)new ContainsFilterConstraint())).put(MatchMode.NOT_CONTAINS, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new ContainsFilterConstraint()))).put(MatchMode.EXACT, (StartsWithFilterConstraint)((Object)new ExactFilterConstraint())).put(MatchMode.NOT_EXACT, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new ExactFilterConstraint()))).put(MatchMode.LESS_THAN, (StartsWithFilterConstraint)((Object)new LessThanFilterConstraint())).put(MatchMode.LESS_THAN_EQUALS, (StartsWithFilterConstraint)((Object)new LessThanEqualsFilterConstraint())).put(MatchMode.GREATER_THAN, (StartsWithFilterConstraint)((Object)new GreaterThanFilterConstraint())).put(MatchMode.GREATER_THAN_EQUALS, (StartsWithFilterConstraint)((Object)new GreaterThanEqualsFilterConstraint())).put(MatchMode.EQUALS, (StartsWithFilterConstraint)((Object)new EqualsFilterConstraint())).put(MatchMode.NOT_EQUALS, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new EqualsFilterConstraint()))).put(MatchMode.IN, (StartsWithFilterConstraint)((Object)new InFilterConstraint())).put(MatchMode.NOT_IN, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new InFilterConstraint()))).put(MatchMode.GLOBAL, (StartsWithFilterConstraint)((Object)new GlobalFilterConstraint())).put(MatchMode.BETWEEN, (StartsWithFilterConstraint)((Object)new BetweenFilterConstraint())).put(MatchMode.NOT_BETWEEN, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new BetweenFilterConstraint()))).build();

    private FilterConstraints() {
    }

    public static FilterConstraint of(MatchMode mode) {
        return Optional.ofNullable(ALL_CONSTRAINTS.get((Object)mode)).orElseThrow(() -> new FacesException("No filter constraint found for match mode: " + String.valueOf((Object)mode)));
    }

    public static FilterConstraint of(String matchMode) {
        MatchMode mode = MatchMode.of(matchMode);
        return FilterConstraints.of(mode);
    }
}

