/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuGroup;
import org.primefaces.model.menu.MenuModel;
import org.primefaces.util.LangUtils;

public class BaseMenuModel
implements MenuModel,
Serializable {
    public static final String ID_SEPARATOR = "_";
    public static final String COORDINATES_SEPARATOR = "|";
    private static final long serialVersionUID = 1L;
    private List<MenuElement> elements = new ArrayList<MenuElement>();

    @Override
    public List<MenuElement> getElements() {
        return this.elements;
    }

    @Override
    public void generateUniqueIds() {
        this.generateUniqueIds(this.getElements(), null);
    }

    private void generateUniqueIds(List<MenuElement> elements, String seed) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        int counter = 0;
        boolean root = seed == null;
        for (MenuElement element : elements) {
            Object coordinates;
            String id = element.getId();
            Object object = coordinates = root ? String.valueOf(counter++) : seed + ID_SEPARATOR + counter++;
            if (LangUtils.isBlank(id)) {
                String submenu = root ? ID_SEPARATOR : "";
                String menuId = String.format("%s%s%s%s", submenu, UUID.randomUUID(), COORDINATES_SEPARATOR, coordinates);
                element.setId(menuId);
            }
            if (!(element instanceof MenuGroup)) continue;
            this.generateUniqueIds(((MenuGroup)element).getElements(), (String)coordinates);
        }
    }
}

