/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import java.io.IOException;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;

public class RendererUtils {
    public static final String SCRIPT_TYPE = "text/javascript";

    private RendererUtils() {
    }

    public static void encodeCheckbox(FacesContext context, boolean checked) throws IOException {
        RendererUtils.encodeCheckbox(context, checked, false, false, null);
    }

    public static void encodeCheckbox(FacesContext context, boolean checked, boolean partialSelected, boolean disabled, String styleClass) throws IOException {
        Object containerClass;
        ResponseWriter writer = context.getResponseWriter();
        Object boxClass = disabled ? "ui-chkbox-box ui-widget ui-corner-all ui-state-default ui-state-disabled" : "ui-chkbox-box ui-widget ui-corner-all ui-state-default";
        boxClass = (String)boxClass + (checked ? " ui-state-active" : "");
        Object object = containerClass = styleClass == null ? "ui-chkbox ui-widget" : "ui-chkbox ui-widget " + styleClass;
        String icon = checked ? "ui-chkbox-icon ui-icon ui-icon-check ui-c" : (partialSelected ? "ui-chkbox-icon ui-icon ui-icon-minus ui-c" : "ui-chkbox-icon ui-icon ui-icon-blank ui-c");
        writer.startElement("div", null);
        writer.writeAttribute("class", containerClass, null);
        writer.startElement("div", null);
        writer.writeAttribute("class", boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)icon, null);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }

    public static RenderKit getRenderKit(FacesContext context) {
        String renderKitId = null;
        UIViewRoot view = context.getViewRoot();
        if (view != null) {
            renderKitId = view.getRenderKitId();
        }
        if (renderKitId == null) {
            Application application = context.getApplication();
            ViewHandler viewHandler = application.getViewHandler();
            if (viewHandler != null) {
                renderKitId = viewHandler.calculateRenderKitId(context);
            }
            if (renderKitId == null && (renderKitId = application.getDefaultRenderKitId()) == null) {
                renderKitId = "HTML_BASIC";
            }
        }
        return ((RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory")).getRenderKit(context, renderKitId);
    }

    public static void encodeScriptTypeIfNecessary(FacesContext context) throws IOException {
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance(context);
        PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
        if (applicationContext.getConfig().isHtml5Compliant()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.writeAttribute("type", (Object)SCRIPT_TYPE, null);
    }
}

