/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.FacesWrapper;
import jakarta.faces.application.ConfigurableNavigationHandler;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.StateHelper;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIData;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlOutputFormat;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.component.api.FlexAware;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.TouchAware;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UITabPanel;
import org.primefaces.component.api.UITable;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.csp.CspResponseWriter;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.BeanUtils;
import org.primefaces.util.Callbacks;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.FastStringWriter;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;

public class ComponentUtils {
    public static final Set<VisitHint> VISIT_HINTS_SKIP_UNRENDERED = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_UNRENDERED));
    public static final Lazy<Set<VisitHint>> VISIT_HINTS_SKIP_ITERATION = new Lazy(() -> Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_ITERATION)));
    private static final Object UNDEFINED_VALUE = new Object();
    private static final Pattern ID_PATTERN = Pattern.compile("\\sid=\"(.*?)\"");

    private ComponentUtils() {
    }

    public static String getValueToRender(FacesContext context, UIComponent component) {
        return ComponentUtils.getValueToRender(context, component, UNDEFINED_VALUE);
    }

    public static String getValueToRender(FacesContext context, UIComponent component, Object value) {
        if (component instanceof ValueHolder) {
            if (component instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)component;
                Object submittedValue = input.getSubmittedValue();
                PrimeConfiguration config = PrimeApplicationContext.getCurrentInstance(context).getConfig();
                if (config.isInterpretEmptyStringAsNull() && submittedValue == null && !input.isLocalValueSet() && context.isValidationFailed() && !input.isValid()) {
                    return null;
                }
                if (submittedValue != null) {
                    return submittedValue.toString();
                }
            }
            ValueHolder valueHolder = (ValueHolder)component;
            if (value == UNDEFINED_VALUE) {
                value = component instanceof HtmlOutputFormat ? ComponentUtils.encodeComponent(component, context) : valueHolder.getValue();
            }
            if (value != null) {
                Converter converter = valueHolder.getConverter();
                if (converter == null) {
                    Class<?> valueType = value.getClass();
                    if (valueType == String.class && !PrimeApplicationContext.getCurrentInstance(context).getConfig().isStringConverterAvailable()) {
                        return (String)value;
                    }
                    converter = context.getApplication().createConverter(valueType);
                }
                if (converter != null) {
                    return converter.getAsString(context, component, value);
                }
                return value.toString();
            }
            return null;
        }
        return null;
    }

    public static Converter getConverter(FacesContext context, UIComponent component) {
        if (!(component instanceof ValueHolder)) {
            return null;
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        Class converterType = valueExpression.getType(context.getELContext());
        return ComponentUtils.getConverter(context, converterType);
    }

    public static Object getConvertedValue(FacesContext context, UIComponent component, Object value) {
        return ComponentUtils.getConvertedValue(context, component, ComponentUtils.getConverter(context, component), value);
    }

    public static Object getConvertedValue(FacesContext context, UIComponent component, Object converter, Object value) {
        Converter converterObject = ComponentUtils.toConverter(context, converter);
        if (converterObject != null) {
            String submittedValue = Objects.toString(value, null);
            if (LangUtils.isBlank(submittedValue)) {
                submittedValue = null;
            }
            return converterObject.getAsObject(context, component, submittedValue);
        }
        return value;
    }

    public static String getConvertedAsString(FacesContext context, UIComponent component, Object value) {
        return ComponentUtils.getConvertedAsString(context, component, null, value);
    }

    public static String getConvertedAsString(FacesContext context, UIComponent component, Object converter, Object value) {
        if (value != null) {
            Converter converterObject = ComponentUtils.toConverter(context, converter);
            if (converterObject == null) {
                converterObject = ComponentUtils.getConverter(context, value.getClass());
            }
            if (converterObject != null) {
                return converterObject.getAsString(context, component, value);
            }
        }
        return Objects.toString(value, null);
    }

    public static Converter getConverter(FacesContext context, Class<?> forClass) {
        if (forClass == null || forClass == Object.class || forClass == String.class && !PrimeApplicationContext.getCurrentInstance(context).getConfig().isStringConverterAvailable()) {
            return null;
        }
        return context.getApplication().createConverter(forClass);
    }

    public static Converter toConverter(FacesContext context, Object converter) {
        if (converter == null) {
            return null;
        }
        if (converter instanceof Converter) {
            return (Converter)converter;
        }
        if (converter instanceof String) {
            return context.getApplication().createConverter((String)converter);
        }
        throw new FacesException("Unsupported type: " + String.valueOf(converter.getClass()));
    }

    public static void decodeBehaviors(FacesContext context, UIComponent component) {
        List behaviorsForEvent;
        if (!(component instanceof ClientBehaviorHolder)) {
            return;
        }
        Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String behaviorEvent = (String)params.get("jakarta.faces.behavior.event");
        if (null != behaviorEvent && (behaviorsForEvent = (List)behaviors.get(behaviorEvent)) != null && !behaviorsForEvent.isEmpty()) {
            String behaviorSource = (String)params.get("jakarta.faces.source");
            String clientId = component.getClientId(context);
            if (behaviorSource != null && clientId.equals(behaviorSource)) {
                for (ClientBehavior behavior : behaviorsForEvent) {
                    behavior.decode(context, component);
                }
            }
        }
    }

    public static String escapeSelector(String selector) {
        return selector.replace(":", "\\\\:");
    }

    public static boolean isRTL(FacesContext context, RTLAware component) {
        return component.isRTL() || PrimeRequestContext.getCurrentInstance(context).isRTL();
    }

    public static boolean isTouchable(FacesContext context, TouchAware component) {
        Boolean local = component.isTouchable();
        if (local != null) {
            return local;
        }
        return PrimeRequestContext.getCurrentInstance(context).isTouchable();
    }

    public static boolean isFlex(FacesContext context, FlexAware component) {
        return component.isFlex() || PrimeRequestContext.getCurrentInstance(context).isFlex();
    }

    public static void processDecodesOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processDecodes(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processDecodes(context);
            }
        }
    }

    public static void processValidatorsOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processValidators(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processValidators(context);
            }
        }
    }

    public static void processUpdatesOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processUpdates(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processUpdates(context);
            }
        }
    }

    public static NavigationCase findNavigationCase(FacesContext context, String outcome) {
        ConfigurableNavigationHandler navHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
        String outcomeValue = outcome == null ? context.getViewRoot().getViewId() : outcome;
        return navHandler.getNavigationCase(context, null, outcomeValue);
    }

    public static Map<String, List<String>> getUIParams(UIComponent component) {
        LinkedHashMap<String, ArrayList<String>> params = null;
        for (int i = 0; i < component.getChildCount(); ++i) {
            ArrayList<String> paramValues;
            UIParameter uiParam;
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (!child.isRendered() || !(child instanceof UIParameter) || (uiParam = (UIParameter)child).isDisable()) continue;
            if (params == null) {
                params = new LinkedHashMap<String, ArrayList<String>>(5);
            }
            if ((paramValues = (ArrayList<String>)params.get(uiParam.getName())) == null) {
                paramValues = new ArrayList<String>(2);
                params.put(uiParam.getName(), paramValues);
            }
            paramValues.add(String.valueOf(uiParam.getValue()));
        }
        return params;
    }

    public static boolean isSkipIteration(VisitContext visitContext, FacesContext context) {
        return visitContext.getHints().contains(VisitHint.SKIP_ITERATION);
    }

    public static <T extends Renderer> T getUnwrappedRenderer(FacesContext context, String family, String rendererType) {
        Renderer renderer = context.getRenderKit().getRenderer(family, rendererType);
        while (renderer instanceof FacesWrapper) {
            renderer = (Renderer)((FacesWrapper)renderer).getWrapped();
        }
        return (T)renderer;
    }

    public static String calculateViewId(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String viewId = (String)requestMap.get("jakarta.servlet.include.path_info");
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)requestMap.get("jakarta.servlet.include.servlet_path");
        }
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestServletPath();
        }
        return viewId;
    }

    public static String encodeURI(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string, "UTF-8").replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
    }

    public static String createContentDisposition(String value, String filename) {
        try {
            return String.format("%s;filename=\"%2$s\"; filename*=UTF-8''%2$s", value, ComponentUtils.encodeURI(filename));
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static boolean isRequestSource(UIComponent component, FacesContext context) {
        String partialSource = (String)context.getExternalContext().getRequestParameterMap().get("jakarta.faces.source");
        return component.getClientId(context).equals(partialSource);
    }

    public static boolean isRequestSource(UIComponent component, FacesContext context, String event) {
        ExternalContext externalContext = context.getExternalContext();
        String partialSource = (String)externalContext.getRequestParameterMap().get("jakarta.faces.source");
        String partialEvent = (String)externalContext.getRequestParameterMap().get("jakarta.faces.behavior.event");
        return component.getClientId(context).equals(partialSource) && partialEvent.equals(event);
    }

    public static Object getLabel(FacesContext facesContext, UIComponent component) {
        String label = (String)component.getAttributes().get("label");
        if (label == null) {
            label = component.getClientId(facesContext);
        }
        return label;
    }

    @Deprecated
    public static boolean shouldRenderFacet(UIComponent facet, boolean alwaysRender) {
        return FacetUtils.shouldRenderFacet(facet, alwaysRender);
    }

    @Deprecated
    public static boolean shouldRenderFacet(UIComponent facet) {
        return FacetUtils.shouldRenderFacet(facet);
    }

    public static boolean shouldRenderChildren(UIComponent component) {
        for (int i = 0; i < component.getChildCount(); ++i) {
            if (!((UIComponent)component.getChildren().get(i)).isRendered()) continue;
            return true;
        }
        return false;
    }

    public static <T> T eval(StateHelper stateHelper, Serializable key, Supplier<T> defaultValueSupplier) {
        Object value = stateHelper.eval(key, null);
        if (value == null) {
            value = defaultValueSupplier.get();
        }
        return (T)value;
    }

    public static <T> T computeIfAbsent(StateHelper stateHelper, Serializable key, Supplier<T> defaultValueSupplier) {
        Object value = stateHelper.get(key);
        if (value == null) {
            value = defaultValueSupplier.get();
            stateHelper.put(key, value);
        }
        return (T)value;
    }

    public static ViewPoolingResetMode isViewPooling(FacesContext context) {
        if (context.getViewRoot() != null) {
            Object mode = context.getViewRoot().getAttributes().get("oam.view.resetSaveStateMode");
            if (Objects.equals(mode, 1)) {
                return ViewPoolingResetMode.SOFT;
            }
            if (Objects.equals(mode, 2)) {
                return ViewPoolingResetMode.HARD;
            }
        }
        return ViewPoolingResetMode.OFF;
    }

    public static boolean isNestedWithinIterator(UIComponent component) {
        UIComponent parent = component;
        while (null != (parent = parent.getParent())) {
            if (!(parent instanceof UIData) && !ComponentUtils.isUIRepeat(parent) && (!(parent instanceof UITabPanel) || !((UITabPanel)parent).isRepeating())) continue;
            return true;
        }
        return false;
    }

    public static void encodeIndexedId(FacesContext context, UIComponent component, int index) throws IOException {
        ResponseWriter originalWriter = context.getResponseWriter();
        FastStringWriter fsw = new FastStringWriter();
        ResponseWriter clonedWriter = originalWriter.cloneWithWriter((Writer)fsw);
        context.setResponseWriter(clonedWriter);
        component.encodeAll(context);
        context.setResponseWriter(originalWriter);
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        String encodedComponent = fsw.toString();
        if (clonedWriter instanceof CspResponseWriter) {
            CspResponseWriter cspWriter = (CspResponseWriter)clonedWriter;
            Matcher matcher = ID_PATTERN.matcher(encodedComponent);
            while (matcher.find()) {
                String oldId = matcher.group(1);
                String newId = oldId + separator + index;
                cspWriter.updateId(oldId, newId);
            }
        }
        encodedComponent = encodedComponent.replaceAll("\\sid=\"(.*?)\"", " id=\"$1" + separator + index + "\"");
        encodedComponent = encodedComponent.replaceAll("source:&quot;(.*?)&quot;", " source:&quot;$1" + separator + index + "&quot;");
        originalWriter.write(encodedComponent);
    }

    public static Object getDynamicColumnValue(UIComponent component) {
        UIColumn column = ComponentTraversalUtils.closest(UIColumn.class, component);
        UITable table = ComponentTraversalUtils.closest(UITable.class, (UIComponent)column);
        return table.getFieldValue(FacesContext.getCurrentInstance(), column);
    }

    public static String getDynamicColumnValueAsString(UIComponent component) {
        UIColumn column = ComponentTraversalUtils.closest(UIColumn.class, component);
        UITable table = ComponentTraversalUtils.closest(UITable.class, (UIComponent)column);
        return table.getConvertedFieldValue(FacesContext.getCurrentInstance(), column);
    }

    public static String encodeComponent(UIComponent component, FacesContext context) {
        FastStringWriter output = new FastStringWriter();
        ResponseWriter originalWriter = context.getResponseWriter();
        if (originalWriter != null) {
            context.setResponseWriter(originalWriter.cloneWithWriter((Writer)output));
        } else {
            context.setResponseWriter(RendererUtils.getRenderKit(context).createResponseWriter((Writer)output, "text/html", "UTF-8"));
        }
        try {
            component.encodeAll(context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (originalWriter != null) {
                context.setResponseWriter(originalWriter);
            }
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeInRequestScope(FacesContext context, String var, Object value, Supplier<T> callback) {
        if (LangUtils.isBlank(var)) {
            return callback.get();
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        Object oldValue = requestMap.remove(var);
        try {
            requestMap.put(var, value);
            T t = callback.get();
            return t;
        }
        finally {
            requestMap.remove(var);
            if (oldValue != null) {
                requestMap.put(var, oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> void runWithoutFacesContextVar(FacesContext context, String var, Callbacks.FailableRunnable<E> runnable) throws E {
        if (LangUtils.isBlank(var)) {
            runnable.run();
            return;
        }
        Map stateMap = context.getAttributes();
        Object oldValue = stateMap.remove(var);
        try {
            runnable.run();
        }
        finally {
            if (oldValue != null) {
                stateMap.put(var, oldValue);
            }
        }
    }

    public static int getRenderedChildCount(UIComponent component) {
        int renderedChildCount = 0;
        for (int i = 0; i < component.getChildCount(); ++i) {
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (!child.isRendered()) continue;
            ++renderedChildCount;
        }
        return renderedChildCount;
    }

    public static boolean isDisabledOrReadonly(UIInput component) {
        return Boolean.parseBoolean(String.valueOf(component.getAttributes().get("disabled"))) || Boolean.parseBoolean(String.valueOf(component.getAttributes().get("readonly")));
    }

    public static boolean isUIRepeat(UIComponent component) {
        return component.getClass().getName().endsWith("UIRepeat");
    }

    public static Object convertToType(Object value, Class<?> valueType, Logger logger) {
        Converter targetConverter;
        if (value == null) {
            return null;
        }
        if (valueType.isAssignableFrom(value.getClass())) {
            return value;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (BeanUtils.isPrimitiveOrPrimitiveWrapper(valueType)) {
            try {
                return context.getELContext().convertToType(value, valueType);
            }
            catch (ELException e) {
                logger.log(Level.INFO, e, () -> "Could not convert '" + String.valueOf(value) + "' to " + String.valueOf(valueType) + " via ELContext!");
            }
        }
        if ((targetConverter = context.getApplication().createConverter(valueType)) == null) {
            logger.log(Level.FINE, () -> "Skip conversion as no converter was found for " + String.valueOf(valueType) + "; Create a JSF Converter for it!");
            return value;
        }
        Converter sourceConverter = context.getApplication().createConverter(value.getClass());
        if (sourceConverter == null) {
            logger.log(Level.FINE, () -> "Skip conversion as no converter was found for " + String.valueOf(value.getClass()) + "; Create a JSF Converter for it!");
        }
        String stringValue = sourceConverter == null ? value.toString() : sourceConverter.getAsString(context, UIComponent.getCurrentComponent((FacesContext)context), value);
        try {
            return targetConverter.getAsObject(context, UIComponent.getCurrentComponent((FacesContext)context), stringValue);
        }
        catch (ConverterException e) {
            logger.log(Level.INFO, e, () -> "Could not convert '" + stringValue + "' to " + String.valueOf(valueType) + " via " + targetConverter.getClass().getName());
            return value;
        }
    }

    public static enum ViewPoolingResetMode {
        OFF,
        SOFT,
        HARD;

    }
}

