/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.FacesException;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.AttachedObjectTarget;
import jakarta.faces.view.EditableValueHolderAttachedObjectTarget;
import java.beans.BeanInfo;
import java.util.List;
import org.primefaces.util.ComponentUtils;

public class CompositeUtils {
    private CompositeUtils() {
    }

    public static boolean isComposite(UIComponent component) {
        return UIComponent.isCompositeComponent((UIComponent)component);
    }

    public static void invokeOnDeepestEditableValueHolder(FacesContext context, UIComponent composite, ContextCallback callback) {
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
        composite.visitTree(visitContext, (VisitCallback)new EditableValueHolderVisitCallback(callback));
    }

    private static class EditableValueHolderVisitCallback
    implements VisitCallback {
        private final ContextCallback callback;

        public EditableValueHolderVisitCallback(ContextCallback callback) {
            this.callback = callback;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (target instanceof EditableValueHolder) {
                this.callback.invokeContextCallback(context.getFacesContext(), target);
                return VisitResult.COMPLETE;
            }
            if (UIComponent.isCompositeComponent((UIComponent)target)) {
                return this.visitEditableValueHolderTargets(context, target);
            }
            return VisitResult.ACCEPT;
        }

        private VisitResult visitEditableValueHolderTargets(VisitContext visitContext, UIComponent component) {
            BeanInfo info = (BeanInfo)component.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
            List targets = (List)info.getBeanDescriptor().getValue("jakarta.faces.view.AttachedObjectTargets");
            if (targets != null) {
                for (int i = 0; i < targets.size(); ++i) {
                    AttachedObjectTarget target = (AttachedObjectTarget)targets.get(i);
                    if (!(target instanceof EditableValueHolderAttachedObjectTarget)) continue;
                    List children = target.getTargets(component);
                    if (children == null || children.isEmpty()) {
                        throw new FacesException("Cannot resolve <cc:editableValueHolder /> target in component with id: \"" + component.getClientId() + "\"");
                    }
                    for (int j = 0; j < children.size(); ++j) {
                        UIComponent child = (UIComponent)children.get(j);
                        if (!child.visitTree(visitContext, (VisitCallback)this)) continue;
                        return VisitResult.COMPLETE;
                    }
                }
            }
            return VisitResult.ACCEPT;
        }
    }
}

