/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.context.FacesContext;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.CompositeUtils;

public class FacetUtils {
    private FacetUtils() {
    }

    public static boolean shouldRenderFacet(UIComponent facet, boolean alwaysRender) {
        if (facet == null) {
            return false;
        }
        if (alwaysRender) {
            return true;
        }
        if (facet.getClass().equals(UIPanel.class)) {
            if (!facet.isRendered()) {
                return false;
            }
            return ComponentUtils.shouldRenderChildren(facet);
        }
        return facet.isRendered();
    }

    public static boolean shouldRenderFacet(UIComponent facet) {
        return FacetUtils.shouldRenderFacet(facet, false);
    }

    @Deprecated
    public static void invokeOnEditableValueHolder(FacesContext context, UIComponent facet, ContextCallback callback) {
        CompositeUtils.invokeOnDeepestEditableValueHolder(context, facet, callback);
    }
}

