/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;

public class MessageFactory {
    private static final String DEFAULT_BUNDLE_BASENAME = "jakarta.faces.Messages";
    private static final String PRIMEFACES_BUNDLE_BASENAME = "org.primefaces.Messages";
    private static final String DEFAULT_DETAIL_SUFFIX = "_detail";

    private MessageFactory() {
    }

    public static FacesMessage getFacesMessage(String messageId, FacesMessage.Severity severity, Object ... params) {
        FacesMessage facesMessage = MessageFactory.getFacesMessage(LocaleUtils.getCurrentLocale(), messageId, params);
        facesMessage.setSeverity(severity);
        return facesMessage;
    }

    public static FacesMessage getFacesMessage(Locale locale, String messageId, Object ... params) {
        String summary = null;
        String detail = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        String userBundleName = application.getMessageBundle();
        ResourceBundle bundle = null;
        ClassLoader currentClassLoader = LangUtils.getCurrentClassLoader(application.getClass());
        if (userBundleName != null) {
            try {
                bundle = MessageFactory.getBundle(userBundleName, locale, currentClassLoader, facesContext);
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = MessageFactory.getBundle(PRIMEFACES_BUNDLE_BASENAME, locale, currentClassLoader, facesContext);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = MessageFactory.getBundle(DEFAULT_BUNDLE_BASENAME, locale, currentClassLoader, facesContext);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        summary = MessageFactory.getFormattedText(locale, summary, params);
        if (bundle != null) {
            try {
                String detailMessageId = messageId + DEFAULT_DETAIL_SUFFIX;
                if (bundle.containsKey(detailMessageId)) {
                    detail = MessageFactory.getFormattedText(locale, bundle.getString(detailMessageId), params);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return new FacesMessage(summary, detail);
    }

    public static String getMessage(String messageId, Object ... params) {
        return MessageFactory.getMessage(LocaleUtils.getCurrentLocale(), messageId, params);
    }

    public static String getMessage(Locale locale, String messageId, Object ... params) {
        String summary = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        String userBundleName = application.getMessageBundle();
        ResourceBundle bundle = null;
        ClassLoader currentClassLoader = LangUtils.getCurrentClassLoader(application.getClass());
        if (userBundleName != null) {
            try {
                bundle = MessageFactory.getBundle(userBundleName, locale, currentClassLoader, facesContext);
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = MessageFactory.getBundle(PRIMEFACES_BUNDLE_BASENAME, locale, currentClassLoader, facesContext);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = MessageFactory.getBundle(DEFAULT_BUNDLE_BASENAME, locale, currentClassLoader, facesContext);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        summary = MessageFactory.getFormattedText(locale, summary, params);
        return summary;
    }

    public static String getFormattedText(Locale locale, String message, Object ... params) {
        if (params == null || params.length == 0 || LangUtils.isBlank(message)) {
            return message;
        }
        MessageFormat messageFormat = null;
        messageFormat = locale != null ? new MessageFormat(message, locale) : new MessageFormat(message);
        return messageFormat.format(params);
    }

    private static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader, FacesContext facesContext) {
        ClassLoader jsfImplClassLoader;
        ClassLoader primeFacesClassLoader = MessageFactory.class.getClassLoader();
        if (PRIMEFACES_BUNDLE_BASENAME.equals(baseName)) {
            if (!primeFacesClassLoader.equals(classLoader)) {
                return ResourceBundle.getBundle(baseName, locale, classLoader, new PrimeFacesControl(primeFacesClassLoader));
            }
        } else if (DEFAULT_BUNDLE_BASENAME.equals(baseName) && !(jsfImplClassLoader = MessageFactory.getJSFImplClassLoader(facesContext)).equals(classLoader)) {
            return ResourceBundle.getBundle(baseName, locale, classLoader, new PrimeFacesControl(jsfImplClassLoader));
        }
        return ResourceBundle.getBundle(baseName, locale, classLoader, new PrimeFacesControl(primeFacesClassLoader));
    }

    private static ClassLoader getJSFImplClassLoader(FacesContext facesContext) {
        facesContext = MessageFactory.unwrapFacesContext(facesContext);
        Class facesContextImplClass = FacesContext.class;
        if (facesContext != null) {
            facesContextImplClass = facesContext.getClass();
        }
        return facesContextImplClass.getClassLoader();
    }

    private static FacesContext unwrapFacesContext(FacesContext facesContext) {
        if (!(facesContext instanceof FacesContextWrapper)) {
            return facesContext;
        }
        FacesContextWrapper wrapper = (FacesContextWrapper)facesContext;
        FacesContext unwrapped = wrapper.getWrapped();
        if (unwrapped == null || FacesContext.class.equals(unwrapped.getClass())) {
            return facesContext;
        }
        return MessageFactory.unwrapFacesContext(unwrapped);
    }

    private static final class PrimeFacesControl
    extends ResourceBundle.Control {
        private final ClassLoader osgiBundleClassLoader;

        public PrimeFacesControl(ClassLoader osgiBundleClassLoader) {
            this.osgiBundleClassLoader = osgiBundleClassLoader;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader classLoader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            ResourceBundle resourceBundle = this.createUnicodeBundle(baseName, locale, format, classLoader, reload);
            if (resourceBundle == null && !this.osgiBundleClassLoader.equals(classLoader)) {
                resourceBundle = this.createUnicodeBundle(baseName, locale, format, this.osgiBundleClassLoader, reload);
            }
            return resourceBundle;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ResourceBundle createUnicodeBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            ResourceBundle bundle = null;
            if ("java.class".equals(format)) {
                try {
                    Class<?> bundleClass = loader.loadClass(bundleName);
                    if (ResourceBundle.class.isAssignableFrom(bundleClass)) return (ResourceBundle)bundleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
                }
                catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException bundleClass) {}
                return bundle;
            }
            if (!"java.properties".equals(format)) throw new IllegalArgumentException("unknown format: " + format);
            String resourceName = this.toResourceName(bundleName, "properties");
            if (resourceName == null) {
                return null;
            }
            try {
                InputStream stream = null;
                if (System.getSecurityManager() != null) {
                    stream = AccessController.doPrivileged(() -> {
                        InputStream is = null;
                        if (reload) {
                            URLConnection connection;
                            URL url = loader.getResource(resourceName);
                            if (url != null && (connection = url.openConnection()) != null) {
                                connection.setUseCaches(false);
                                is = connection.getInputStream();
                            }
                        } else {
                            is = loader.getResourceAsStream(resourceName);
                        }
                        return is;
                    });
                } else if (reload) {
                    URLConnection connection;
                    URL url = loader.getResource(resourceName);
                    if (url != null && (connection = url.openConnection()) != null) {
                        connection.setUseCaches(false);
                        stream = connection.getInputStream();
                    }
                } else {
                    stream = loader.getResourceAsStream(resourceName);
                }
                if (stream == null) return bundle;
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    bundle = new PropertyResourceBundle(reader);
                    return bundle;
                }
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
        }
    }
}

