/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.FacesException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.primefaces.util.LangUtils;

public interface PropertyDescriptorResolver {
    public PropertyDescriptor get(Class<?> var1, String var2);

    public Object getValue(Object var1, String var2);

    public void setValue(Object var1, String var2, Object var3);

    public void flush();

    public static class DefaultResolver
    implements PropertyDescriptorResolver {
        private static final Pattern NESTED_EXPRESSION_PATTERN = Pattern.compile("\\.");
        private final Map<String, Map<String, PropertyDescriptor>> pdCache = new ConcurrentHashMap<String, Map<String, PropertyDescriptor>>();

        @Override
        public PropertyDescriptor get(Class<?> klazz, String expression) {
            PropertyDescriptor pd;
            String cacheKey = klazz.getName();
            Map<String, PropertyDescriptor> classCache = this.pdCache.get(cacheKey);
            if (classCache != null && (pd = classCache.get(expression)) != null) {
                return pd;
            }
            pd = null;
            Class<?> parent = klazz;
            for (String property : NESTED_EXPRESSION_PATTERN.split(expression)) {
                pd = this.getSimpleProperty(parent, property);
                parent = pd.getPropertyType();
            }
            return Objects.requireNonNull(pd);
        }

        @Override
        public Object getValue(Object obj, String expression) {
            try {
                for (String property : NESTED_EXPRESSION_PATTERN.split(expression)) {
                    if ((obj = this.getSimpleProperty(obj.getClass(), property).getReadMethod().invoke(obj, new Object[0])) == null) break;
                }
                return obj;
            }
            catch (ReflectiveOperationException e) {
                throw new FacesException((Throwable)e);
            }
        }

        @Override
        public void setValue(Object obj, String expression, Object value) {
            try {
                String[] expressions = NESTED_EXPRESSION_PATTERN.split(expression);
                for (int i = 0; i < expressions.length; ++i) {
                    boolean lastExpression;
                    String property = expressions[i];
                    boolean bl = lastExpression = i + 1 == expressions.length;
                    if (lastExpression) {
                        Method writeMethod = this.getSimpleProperty(obj.getClass(), property).getWriteMethod();
                        if (writeMethod == null) {
                            throw new FacesException("property '" + property + "' is readonly");
                        }
                        writeMethod.invoke(obj, value);
                        continue;
                    }
                    if ((obj = this.getSimpleProperty(obj.getClass(), property).getReadMethod().invoke(obj, new Object[0])) != null) continue;
                    throw new FacesException("property '" + property + "' resolved to null");
                }
            }
            catch (ReflectiveOperationException e) {
                throw new FacesException((Throwable)e);
            }
        }

        @Override
        public void flush() {
            this.pdCache.clear();
        }

        private PropertyDescriptor getSimpleProperty(Class<?> klazz, String property) {
            String cacheKey = klazz.getName();
            return this.pdCache.computeIfAbsent(cacheKey, k -> new ConcurrentHashMap()).computeIfAbsent(property, k -> {
                try {
                    return new PropertyDescriptor((String)k, klazz);
                }
                catch (IntrospectionException e) {
                    try {
                        return new PropertyDescriptor((String)k, klazz, "is" + LangUtils.capitalize(k), null);
                    }
                    catch (IntrospectionException e2) {
                        throw new FacesException((Throwable)e2);
                    }
                }
            });
        }
    }
}

