/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.validate;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.html.HtmlInputFile;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import jakarta.servlet.http.Part;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.model.file.NativeUploadedFile;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.model.file.UploadedFiles;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.validate.ClientValidator;
import org.primefaces.virusscan.VirusException;

public class FileValidator
implements Validator,
PartialStateHolder,
ClientValidator {
    public static final String VALIDATOR_ID = "primefaces.File";
    public static final String FILE_LIMIT_MESSAGE_ID = "primefaces.FileValidator.FILE_LIMIT";
    public static final String ALLOW_TYPES_MESSAGE_ID = "primefaces.FileValidator.ALLOW_TYPES";
    public static final String SIZE_LIMIT_MESSAGE_ID = "primefaces.FileValidator.SIZE_LIMIT";
    private Integer fileLimit;
    private Long sizeLimit;
    private String allowTypes;
    private Boolean contentType;
    private Boolean virusScan;
    private boolean isTransient = false;
    private boolean initialStateMarked = false;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (component instanceof FileUpload) {
            String accept;
            String string = accept = Boolean.TRUE.equals(this.contentType) ? ((FileUpload)component).getAccept() : null;
            if (value instanceof UploadedFile) {
                UploadedFile uploadedFile = (UploadedFile)value;
                this.validateUploadedFile(context, uploadedFile, accept);
            } else if (value instanceof UploadedFiles) {
                UploadedFiles uploadedFiles = (UploadedFiles)value;
                this.validateUploadedFiles(context, uploadedFiles, accept);
            } else if (value != null) {
                throw new IllegalArgumentException("Argument of type '" + value.getClass().getName() + "' not supported");
            }
        } else if (component instanceof HtmlInputFile) {
            String accept;
            String string = accept = Boolean.TRUE.equals(this.contentType) ? (String)component.getAttributes().get("accept") : null;
            if (value instanceof Part) {
                NativeUploadedFile uploadedFile = new NativeUploadedFile((Part)value, this.sizeLimit, null);
                this.validateUploadedFile(context, uploadedFile, accept);
            } else if (value instanceof List) {
                List<UploadedFile> uploadedFiles = ((List)value).stream().map(part -> new NativeUploadedFile((Part)part, this.sizeLimit, null)).collect(Collectors.toList());
                this.validateUploadedFiles(context, new UploadedFiles(uploadedFiles), accept);
            } else if (value != null) {
                throw new IllegalArgumentException("Argument of type '" + value.getClass().getName() + "' not supported");
            }
        } else {
            throw new IllegalArgumentException("Component of type '" + String.valueOf(component.getClass()) + "' not supported");
        }
    }

    protected void validateUploadedFiles(FacesContext context, UploadedFiles uploadedFiles, String accept) {
        if (this.fileLimit != null && uploadedFiles.getFiles().size() > this.fileLimit) {
            throw new ValidatorException(MessageFactory.getFacesMessage(FILE_LIMIT_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, this.fileLimit));
        }
        long totalSize = 0L;
        for (UploadedFile file : uploadedFiles.getFiles()) {
            totalSize += file.getSize();
            this.validateUploadedFile(context, file, accept);
        }
        if (this.sizeLimit != null && totalSize > this.sizeLimit) {
            throw new ValidatorException(MessageFactory.getFacesMessage(SIZE_LIMIT_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, "*", FileUploadUtils.formatBytes(this.sizeLimit, LocaleUtils.getCurrentLocale(context))));
        }
    }

    protected void validateUploadedFile(FacesContext context, UploadedFile uploadedFile, String accept) {
        PrimeApplicationContext applicationContext = PrimeApplicationContext.getCurrentInstance(context);
        if (this.sizeLimit != null && uploadedFile.getSize() > this.sizeLimit) {
            throw new ValidatorException(MessageFactory.getFacesMessage(SIZE_LIMIT_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, uploadedFile.getFileName(), FileUploadUtils.formatBytes(this.sizeLimit, LocaleUtils.getCurrentLocale(context))));
        }
        if (!FileUploadUtils.isValidType(applicationContext, uploadedFile, this.allowTypes, accept)) {
            throw new ValidatorException(MessageFactory.getFacesMessage(ALLOW_TYPES_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, uploadedFile.getFileName(), FileUploadUtils.formatAllowTypes(this.allowTypes)));
        }
        if (Boolean.TRUE.equals(this.virusScan)) {
            try {
                PrimeApplicationContext.getCurrentInstance(context).getVirusScannerService().performVirusScan(uploadedFile);
            }
            catch (VirusException e) {
                throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), ""), (Throwable)((Object)e));
            }
        }
    }

    @Override
    public Map<String, Object> getMetadata() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        if (this.fileLimit != null) {
            metadata.put("data-p-filelimit", this.fileLimit);
        }
        if (this.sizeLimit != null) {
            metadata.put("data-p-sizelimit", this.sizeLimit);
        }
        if (LangUtils.isNotBlank(this.allowTypes)) {
            metadata.put("data-p-allowtypes", this.allowTypes);
        }
        return metadata;
    }

    @Override
    public String getValidatorId() {
        return VALIDATOR_ID;
    }

    public void clearInitialState() {
        this.initialStateMarked = false;
    }

    public boolean initialStateMarked() {
        return this.initialStateMarked;
    }

    public void markInitialState() {
        this.initialStateMarked = true;
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.fileLimit, this.sizeLimit, this.allowTypes, this.contentType, this.virusScan};
            return values;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            this.fileLimit = (Integer)values[0];
            this.sizeLimit = (Long)values[1];
            this.allowTypes = (String)values[2];
            this.contentType = (Boolean)values[3];
            this.virusScan = (Boolean)values[4];
        }
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileValidator that = (FileValidator)o;
        return Objects.equals(this.fileLimit, that.fileLimit) && Objects.equals(this.sizeLimit, that.sizeLimit) && Objects.equals(this.allowTypes, that.allowTypes) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.virusScan, that.virusScan);
    }

    public int hashCode() {
        return Objects.hash(this.fileLimit, this.sizeLimit, this.allowTypes, this.contentType, this.virusScan);
    }

    public Integer getFileLimit() {
        return this.fileLimit;
    }

    public void setFileLimit(Integer fileLimit) {
        this.fileLimit = fileLimit;
    }

    public Long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(Long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public String getAllowTypes() {
        return this.allowTypes;
    }

    public void setAllowTypes(String allowTypes) {
        this.allowTypes = allowTypes;
    }

    public Boolean getContentType() {
        return this.contentType;
    }

    public void setContentType(Boolean contentType) {
        this.contentType = contentType;
    }

    public Boolean getVirusScan() {
        return this.virusScan;
    }

    public void setVirusScan(Boolean virusScan) {
        this.virusScan = virusScan;
    }
}

