/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.virusscan.impl;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.util.Lazy;
import org.primefaces.util.MessageFactory;
import org.primefaces.virusscan.VirusException;
import org.primefaces.virusscan.VirusScanner;
import org.primefaces.virusscan.impl.ClamDaemonClient;

public class ClamDaemonScanner
implements VirusScanner {
    private static final Logger LOGGER = Logger.getLogger(ClamDaemonScanner.class.getName());
    private static final String CONTEXT_PARAM_HOST = "primefaces.virusscan.CLAMAV_HOST";
    private static final String CONTEXT_PARAM_PORT = "primefaces.virusscan.CLAMAV_PORT";
    private static final String CONTEXT_PARAM_TIMEOUT = "primefaces.virusscan.CLAMAV_TIMEOUT";
    private static final String CONTEXT_PARAM_BUFFER = "primefaces.virusscan.CLAMAV_BUFFER";
    private Lazy<ClamDaemonClient> client = new Lazy(() -> {
        String host = "localhost";
        int port = 3310;
        int timeout = 30000;
        int bufferSize = 2048;
        if (FacesContext.getCurrentInstance() != null) {
            ExternalContext ctx = FacesContext.getCurrentInstance().getExternalContext();
            if (ctx.getInitParameter(CONTEXT_PARAM_HOST) != null) {
                host = ctx.getInitParameter(CONTEXT_PARAM_HOST);
            }
            if (ctx.getInitParameter(CONTEXT_PARAM_PORT) != null) {
                port = Integer.parseInt(ctx.getInitParameter(CONTEXT_PARAM_PORT));
            }
            if (ctx.getInitParameter(CONTEXT_PARAM_TIMEOUT) != null) {
                timeout = Integer.parseInt(ctx.getInitParameter(CONTEXT_PARAM_TIMEOUT));
            }
            if (ctx.getInitParameter(CONTEXT_PARAM_BUFFER) != null) {
                bufferSize = Integer.parseInt(ctx.getInitParameter(CONTEXT_PARAM_BUFFER));
            }
        }
        return new ClamDaemonClient(host, port, timeout, bufferSize);
    });

    @Override
    public boolean isEnabled() {
        ExternalContext ctx = FacesContext.getCurrentInstance().getExternalContext();
        return ctx.getInitParameter(CONTEXT_PARAM_HOST) != null && ctx.getInitParameter(CONTEXT_PARAM_PORT) != null;
    }

    @Override
    public void scan(UploadedFile file) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getContent());
            byte[] reply = this.getClamAvClient().scan(inputStream);
            String message = new String(reply, StandardCharsets.US_ASCII).trim();
            LOGGER.log(Level.INFO, "Scanner replied with message: {0}", message);
            if (!ClamDaemonClient.isCleanReply(reply)) {
                String error = this.createErrorMessage(file, message);
                LOGGER.log(Level.WARNING, "ClamAV Error: {0}", error);
                throw new VirusException(error);
            }
        }
        catch (VirusException ex) {
            throw ex;
        }
        catch (IOException | RuntimeException ex) {
            String error = String.format("Unexpected error scanning file - %s", ex.getMessage());
            throw new VirusException(error);
        }
    }

    protected String createErrorMessage(UploadedFile file, String response) {
        return MessageFactory.getMessage("primefaces.fileupload.CLAM_AV_FILE", file.getFileName(), response);
    }

    public ClamDaemonClient getClamAvClient() {
        return this.client.get();
    }
}

