/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.webapp;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.shaded.json.JSONException;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.FileUploadUtils;

public class FileUploadChunksServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(FileUploadChunksServlet.class.getName());

    public void init() throws ServletException {
        String uploader = this.getServletContext().getInitParameter("primefaces.UPLOADER");
        if ("commons".equals(uploader)) {
            throw new ServletException("Resuming chunked file uploads is not supported with commons uploader.");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            long uploadedBytes = FileUploadUtils.getFileUploadChunkDecoder(req).decodeUploadedBytes(req);
            this.printUploadedBytes(resp, uploadedBytes);
        }
        catch (Exception ex) {
            this.sendError(resp, ex);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            FileUploadUtils.getFileUploadChunkDecoder(req).deleteChunks(req);
        }
        catch (IOException ex) {
            this.sendError(resp, ex);
        }
    }

    protected void printUploadedBytes(HttpServletResponse resp, long uploadedBytes) throws IOException {
        try (PrintWriter w = resp.getWriter();){
            resp.setContentType("application/json");
            JSONObject json = new JSONObject();
            json.put("uploadedBytes", uploadedBytes);
            w.print(json.toString());
        }
        catch (IOException | JSONException ex) {
            this.sendError(resp, ex);
        }
    }

    private void sendError(HttpServletResponse resp, Exception ex) {
        try {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            resp.sendError(500);
        }
        catch (IOException ioex) {
            LOGGER.log(Level.SEVERE, ioex.getMessage(), ioex);
        }
    }
}

