/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.webapp;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

@Deprecated(forRemoval=true, since="14.0.0")
public class MultipartRequest
extends HttpServletRequestWrapper {
    private static final Logger LOGGER = Logger.getLogger(MultipartRequest.class.getName());
    private Map<String, List<String>> formParams = new LinkedHashMap<String, List<String>>();
    private Map<String, List<FileItem>> fileParams = new LinkedHashMap<String, List<FileItem>>();
    private Map<String, String[]> parameterMap;
    private File uploadDirectory;

    public MultipartRequest(HttpServletRequest request, ServletFileUpload servletFileUpload) throws IOException {
        super(request);
        this.uploadDirectory = ((DiskFileItemFactory)servletFileUpload.getFileItemFactory()).getRepository();
        this.parseRequest(request, servletFileUpload);
    }

    private void parseRequest(HttpServletRequest request, ServletFileUpload servletFileUpload) throws IOException {
        try {
            List fileItems = servletFileUpload.parseRequest(request);
            for (FileItem item : fileItems) {
                List items;
                if (item.isFormField()) {
                    items = this.formParams.computeIfAbsent(item.getFieldName(), k -> new ArrayList());
                    items.add(this.getItemString(item));
                    continue;
                }
                items = this.fileParams.computeIfAbsent(item.getFieldName(), k -> new ArrayList());
                items.add(item);
            }
        }
        catch (FileUploadException e) {
            throw new IOException("Error in parsing fileupload request", e);
        }
    }

    private String getItemString(FileItem item) {
        try {
            String characterEncoding = this.getRequest().getCharacterEncoding();
            return characterEncoding == null ? item.getString() : item.getString(characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.SEVERE, "Unsupported character encoding {0}", this.getRequest().getCharacterEncoding());
            return item.getString();
        }
    }

    public String getParameter(String name) {
        if (this.formParams.containsKey(name)) {
            List<String> values = this.formParams.get(name);
            if (values.isEmpty()) {
                return "";
            }
            return values.get(0);
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap == null) {
            LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
            for (Map.Entry<String, List<String>> entry : this.formParams.entrySet()) {
                map.put(entry.getKey(), entry.getValue().toArray(new String[0]));
            }
            map.putAll(super.getParameterMap());
            this.parameterMap = Collections.unmodifiableMap(map);
        }
        return this.parameterMap;
    }

    public Enumeration<String> getParameterNames() {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>(this.formParams.keySet());
        Enumeration original = super.getParameterNames();
        while (original.hasMoreElements()) {
            paramNames.add((String)original.nextElement());
        }
        return Collections.enumeration(paramNames);
    }

    public String[] getParameterValues(String name) {
        if (this.formParams.containsKey(name)) {
            List<String> values = this.formParams.get(name);
            if (values.isEmpty()) {
                return new String[0];
            }
            return values.toArray(new String[0]);
        }
        return super.getParameterValues(name);
    }

    public FileItem getFileItem(String name) {
        if (this.fileParams.containsKey(name)) {
            List<FileItem> items = this.fileParams.get(name);
            return items.get(0);
        }
        return null;
    }

    public List<FileItem> getFileItems(String name) {
        if (this.fileParams.containsKey(name)) {
            return this.fileParams.get(name);
        }
        return Collections.emptyList();
    }

    public File getUploadDirectory() {
        return this.uploadDirectory;
    }
}

