/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import java.io.IOException;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.columns.Columns;

public class DynamicColumn
implements UIColumn {
    private final int index;
    private final Columns columns;
    private final String baseColumnKey;
    private final char separatorChar;
    private final String columnKey;

    public DynamicColumn(int index, Columns columns, FacesContext context) {
        this.index = index;
        this.columns = columns;
        this.baseColumnKey = columns.getColumnKey();
        this.separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        this.columnKey = this.baseColumnKey + this.separatorChar + index;
    }

    @Override
    public UIComponent asUIComponent() {
        return this.columns;
    }

    public int getIndex() {
        return this.index;
    }

    public void applyModel() {
        this.columns.setRowIndex(this.index);
    }

    public void applyStatelessModel() {
        this.columns.setRowModel(this.index);
    }

    public void cleanStatelessModel() {
        this.columns.setRowModel(-1);
    }

    public void cleanModel() {
        this.columns.setRowIndex(-1);
    }

    public Columns getColumns() {
        return this.columns;
    }

    @Override
    public ValueExpression getValueExpression(String property) {
        return this.columns.getValueExpression(property);
    }

    @Override
    public String getContainerClientId(FacesContext context) {
        return this.columns.getContainerClientId(context);
    }

    public String getId() {
        return this.columns.getId();
    }

    @Override
    public String getClientId() {
        return this.columns.getClientId();
    }

    @Override
    public String getClientId(FacesContext context) {
        return this.columns.getClientId(context);
    }

    @Override
    public boolean isSelectionBox() {
        return this.columns.isSelectionBox();
    }

    @Override
    public boolean isResizable() {
        return this.columns.isResizable();
    }

    @Override
    public String getStyle() {
        return this.columns.getStyle();
    }

    @Override
    public String getStyleClass() {
        return this.columns.getStyleClass();
    }

    @Override
    public int getRowspan() {
        return this.columns.getRowspan();
    }

    @Override
    public int getColspan() {
        return this.columns.getColspan();
    }

    @Override
    public String getFilterPosition() {
        return this.columns.getFilterPosition();
    }

    @Override
    public UIComponent getFacet(String facet) {
        return this.columns.getFacet(facet);
    }

    @Override
    public String getHeaderText() {
        return this.columns.getHeaderText();
    }

    @Override
    public String getFooterText() {
        return this.columns.getFooterText();
    }

    @Override
    public String getFilterStyleClass() {
        return this.columns.getFilterStyleClass();
    }

    @Override
    public String getFilterStyle() {
        return this.columns.getFilterStyle();
    }

    @Override
    public String getFilterMatchMode() {
        return this.columns.getFilterMatchMode();
    }

    @Override
    public int getFilterMaxLength() {
        return this.columns.getFilterMaxLength();
    }

    @Override
    public CellEditor getCellEditor() {
        return this.columns.getCellEditor();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public MethodExpression getSortFunction() {
        return this.columns.getSortFunction();
    }

    @Override
    public List<UIComponent> getChildren() {
        return this.columns.getChildren();
    }

    @Override
    public boolean isExportable() {
        return this.columns.isExportable();
    }

    @Override
    public boolean isRendered() {
        return this.columns.isRendered();
    }

    @Override
    public void encodeAll(FacesContext context) throws IOException {
        this.columns.encodeAll(context);
    }

    @Override
    public void renderChildren(FacesContext context) throws IOException {
        this.columns.encodeChildren(context);
    }

    @Override
    public String getColumnKey() {
        return this.columnKey;
    }

    @Override
    public String getColumnKey(UIComponent parent, String rowIndex) {
        return this.getColumnKey().replace(parent.getId() + this.separatorChar + rowIndex + this.separatorChar, parent.getId() + this.separatorChar);
    }

    @Override
    public String getWidth() {
        return this.columns.getWidth();
    }

    @Override
    public Object getSortBy() {
        return this.columns.getSortBy();
    }

    @Override
    public Object getFilterBy() {
        return this.columns.getFilterBy();
    }

    @Override
    public boolean isToggleable() {
        return this.columns.isToggleable();
    }

    @Override
    public MethodExpression getFilterFunction() {
        return this.columns.getFilterFunction();
    }

    @Override
    public String getField() {
        return this.columns.getField();
    }

    @Override
    public Object getFilterValue() {
        return this.columns.getFilterValue();
    }

    @Override
    public int getResponsivePriority() {
        return this.columns.getResponsivePriority();
    }

    @Override
    public boolean isSortable() {
        return this.columns.isSortable();
    }

    @Override
    public boolean isFilterable() {
        return this.columns.isFilterable();
    }

    @Override
    public boolean isVisible() {
        return this.columns.isVisible();
    }

    public void setVisible(boolean visible) {
        this.columns.setVisible(visible);
    }

    @Override
    public boolean isSelectRow() {
        return this.columns.isSelectRow();
    }

    @Override
    public String getAriaHeaderText() {
        return this.columns.getAriaHeaderText();
    }

    @Override
    public MethodExpression getExportFunction() {
        return this.columns.getExportFunction();
    }

    @Override
    public boolean isGroupRow() {
        return this.columns.isGroupRow();
    }

    @Override
    public Object getExportHeaderValue() {
        return this.columns.getExportHeaderValue();
    }

    @Override
    public Object getExportFooterValue() {
        return this.columns.getExportFooterValue();
    }

    @Override
    public String getExportTag() {
        return this.columns.getExportTag();
    }

    @Override
    public String getSortOrder() {
        return this.columns.getSortOrder();
    }

    @Override
    public int getSortPriority() {
        return this.columns.getSortPriority();
    }

    @Override
    public int getNullSortOrder() {
        return this.columns.getNullSortOrder();
    }

    @Override
    public boolean isCaseSensitiveSort() {
        return this.columns.isCaseSensitiveSort();
    }

    @Override
    public boolean isDraggable() {
        return this.columns.isDraggable();
    }

    @Override
    public Object getExportValue() {
        return this.columns.getExportValue();
    }

    @Override
    public int getExportRowspan() {
        return this.columns.getExportRowspan();
    }

    @Override
    public int getExportColspan() {
        return this.columns.getExportColspan();
    }

    @Override
    public int getDisplayPriority() {
        return this.columns.getDisplayPriority();
    }

    @Override
    public String getTitle() {
        return this.columns.getTitle();
    }

    @Override
    public String getFilterPlaceholder() {
        return this.columns.getFilterPlaceholder();
    }

    @Override
    public Object getConverter() {
        return this.columns.getConverter();
    }
}

