/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.barcode;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import org.primefaces.application.resource.BaseDynamicContentHandler;
import uk.org.okapibarcode.backend.Codabar;
import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.Code2Of5;
import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.DataMatrix;
import uk.org.okapibarcode.backend.Ean;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.Pdf417;
import uk.org.okapibarcode.backend.Postnet;
import uk.org.okapibarcode.backend.QrCode;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.Upc;
import uk.org.okapibarcode.graphics.Color;
import uk.org.okapibarcode.output.Java2DRenderer;
import uk.org.okapibarcode.output.SvgRenderer;
import uk.org.okapibarcode.util.Integers;

public class BarcodeHandler
extends BaseDynamicContentHandler {
    private static final Logger LOGGER = Logger.getLogger(BarcodeHandler.class.getName());
    private static final Map<String, Supplier<Symbol>> GENERATORS = Map.ofEntries(Map.entry("codabar", Codabar::new), Map.entry("code128", Code128::new), Map.entry("code39", Code3Of9::new), Map.entry("datamatrix", DataMatrix::new), Map.entry("ean13", () -> new Ean(Ean.Mode.EAN13)), Map.entry("ean8", () -> new Ean(Ean.Mode.EAN8)), Map.entry("int2of5", Code2Of5::new), Map.entry("pdf417", Pdf417::new), Map.entry("postnet", Postnet::new), Map.entry("qr", QrCode::new), Map.entry("upca", () -> new Upc(Upc.Mode.UPCA)), Map.entry("upce", () -> new Upc(Upc.Mode.UPCE)));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        ExternalContext externalContext = context.getExternalContext();
        String sessionKey = (String)params.get("pfdrid");
        Map session = externalContext.getSessionMap();
        Map barcodeMapping = (Map)session.get("primefaces.barcodeMapping");
        if (barcodeMapping == null) {
            return;
        }
        String value = (String)barcodeMapping.get(sessionKey);
        if (value == null) {
            return;
        }
        try {
            String type = ((String)params.get("gen")).toLowerCase(Locale.ROOT);
            Symbol generator = GENERATORS.get(type).get();
            String format = ((String)params.get("fmt")).toLowerCase(Locale.ROOT);
            String hrp = (String)params.get("hrp");
            int rotation = Integers.normalizeRotation((int)Integer.parseInt((String)params.get("ori")));
            double magnification = Double.parseDouble((String)params.get("mag"));
            boolean cache = Boolean.parseBoolean((String)params.get("pfdrid_c"));
            generator.setHumanReadableLocation(HumanReadableLocation.valueOf((String)hrp.toUpperCase(Locale.ROOT)));
            generator.setContent(value);
            if (generator instanceof QrCode) {
                ((QrCode)generator).setPreferredEccLevel(QrCode.EccLevel.valueOf((String)((String)params.get("qrec"))));
            }
            switch (rotation) {
                case 90: {
                    rotation = 270;
                    break;
                }
                case 270: {
                    rotation = 90;
                }
            }
            OutputStream out = externalContext.getResponseOutputStream();
            this.handleCache(externalContext, cache);
            if ("png".equals(format)) {
                externalContext.setResponseContentType("image/png");
                int width = generator.getWidth();
                int height = generator.getHeight();
                BufferedImage image = new BufferedImage(width, height, 10);
                Graphics2D g2d = image.createGraphics();
                Java2DRenderer renderer = new Java2DRenderer(g2d, magnification, Color.WHITE, Color.BLACK, rotation);
                renderer.render(generator);
                g2d.dispose();
                ImageIO.write((RenderedImage)image, "png", out);
            } else if ("svg".equals(format)) {
                externalContext.setResponseContentType("image/svg+xml");
                SvgRenderer renderer = new SvgRenderer(out, magnification, Color.WHITE, Color.BLACK, true, rotation);
                renderer.render(generator);
            }
            externalContext.setResponseStatus(200);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error in streaming barcode resource. {0}", new Object[]{e.getMessage()});
        }
        finally {
            externalContext.responseFlushBuffer();
            context.responseComplete();
        }
    }
}

