/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.captcha;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.captcha.Captcha;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class CaptchaRenderer
extends CoreRenderer {
    private static final Logger LOGGER = Logger.getLogger(CaptchaRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        Captcha captcha = (Captcha)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String answer = (String)params.get(String.format("%s-response", captcha.getType()));
        if (answer != null) {
            captcha.setSubmittedValue(answer);
        } else {
            captcha.setSubmittedValue("");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Captcha captcha = (Captcha)component;
        String publicKey = this.getPublicKey(context, captcha);
        if (publicKey == null) {
            throw new FacesException("Cannot find public key for catpcha, use primefaces.PUBLIC_CAPTCHA_KEY context-param to define one");
        }
        switch (captcha.getType()) {
            case "g-recaptcha": {
                if (LangUtils.isBlank(captcha.getSourceUrl())) {
                    captcha.setSourceUrl("https://www.google.com/recaptcha/api.js");
                }
                if (LangUtils.isBlank(captcha.getVerifyUrl())) {
                    captcha.setVerifyUrl("https://www.google.com/recaptcha/api/siteverify");
                }
                if (!LangUtils.isBlank(captcha.getExecutor())) break;
                captcha.setExecutor("grecaptcha");
                break;
            }
            case "h-captcha": {
                if (LangUtils.isBlank(captcha.getSourceUrl())) {
                    captcha.setSourceUrl("https://js.hcaptcha.com/1/api.js");
                }
                if (LangUtils.isBlank(captcha.getVerifyUrl())) {
                    captcha.setVerifyUrl("https://api.hcaptcha.com/siteverify");
                }
                if (!LangUtils.isBlank(captcha.getExecutor())) break;
                captcha.setExecutor("hcaptcha");
                break;
            }
            default: {
                throw new FacesException(String.format("Captcha type must be one of %s", List.of("g-recaptcha", "h-captcha")));
            }
        }
        this.encodeMarkup(context, captcha, publicKey);
        this.encodeScript(context, captcha, publicKey);
    }

    protected void encodeMarkup(FacesContext context, Captcha captcha, String publicKey) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = captcha.getClientId(context);
        captcha.setRequired(true);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (captcha.getSize() != null && "invisible".equals(captcha.getSize())) {
            writer.writeAttribute("class", (Object)captcha.getType(), null);
            writer.writeAttribute("data-sitekey", (Object)publicKey, null);
            writer.writeAttribute("data-size", (Object)"invisible", null);
        }
        this.renderDynamicPassThruAttributes(context, (UIComponent)captcha);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Captcha captcha, String publicKey) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Captcha", captcha);
        wb.attr("sitekey", publicKey).attr("theme", captcha.getTheme(), "auto").attr("language", captcha.getLanguage(), "en").attr("tabindex", captcha.getTabindex(), 0).attr("callback", captcha.getCallback(), null).attr("expired", captcha.getExpired(), null).attr("size", captcha.getSize(), null).attr("executor", captcha.getExecutor(), null).attr("sourceUrl", captcha.getSourceUrl(), null);
        wb.finish();
    }

    protected String getPublicKey(FacesContext context, Captcha captcha) {
        String publicKey = context.getExternalContext().getInitParameter("primefaces.PUBLIC_CAPTCHA_KEY");
        try {
            if (publicKey != null) {
                publicKey = (String)context.getApplication().evaluateExpressionGet(context, publicKey, String.class);
            }
        }
        catch (ELException e) {
            LOGGER.fine(() -> "Error processing context parameter primefaces.PUBLIC_CAPTCHA_KEY as EL-expression: " + e.getMessage());
        }
        return publicKey;
    }
}

