/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.card;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.card.Card;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.LangUtils;

public class CardRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Card card = (Card)component;
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-card ui-widget ui-widget-content").add(card.getStyleClass()).build();
        writer.startElement("div", (UIComponent)card);
        writer.writeAttribute("id", (Object)card.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (LangUtils.isNotBlank(card.getStyle())) {
            writer.writeAttribute("style", (Object)card.getStyle(), "style");
        }
        this.encodeCardTextOrFacet(context, card, card.getHeader(), "header", "ui-card-header");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-card-body", null);
        this.encodeCardTextOrFacet(context, card, card.getTitle(), "title", "ui-card-title");
        this.encodeCardTextOrFacet(context, card, card.getSubtitle(), "subtitle", "ui-card-subtitle");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-card-content", null);
        this.renderChildren(context, (UIComponent)card);
        writer.endElement("div");
        this.encodeCardTextOrFacet(context, card, card.getFooter(), "footer", "ui-card-footer");
        writer.endElement("div");
        writer.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext fc, UIComponent component) {
    }

    protected void encodeCardTextOrFacet(FacesContext context, Card card, String value, String facetName, String cssClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (LangUtils.isNotBlank(value)) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)cssClass, null);
            writer.writeText((Object)value, null);
            writer.endElement("div");
        } else {
            UIComponent facet = card.getFacet(facetName);
            if (FacetUtils.shouldRenderFacet(facet)) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)cssClass, null);
                facet.encodeAll(context);
                writer.endElement("div");
            }
        }
    }
}

