/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.ListDataModel;
import org.primefaces.PrimeFaces;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.DataTableState;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatures;
import org.primefaces.event.data.PostSortEvent;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.SortTableComparator;

public class SortFeature
implements DataTableFeature {
    private boolean isSortRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_sorting");
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        String[] sortOrders;
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String sortKey = (String)params.get(clientId + "_sortKey");
        String sortDir = (String)params.get(clientId + "_sortDir");
        String[] sortKeys = sortKey.split(",");
        if (sortKeys.length != (sortOrders = sortDir.split(",")).length) {
            throw new FacesException("sortKeys != sortDirs");
        }
        Map<String, SortMeta> sortByMap = table.getSortByAsMap();
        Map<String, Integer> sortKeysIndexes = IntStream.range(0, sortKeys.length).boxed().collect(Collectors.toMap(i -> sortKeys[i], i -> i));
        for (Map.Entry<String, SortMeta> entry : sortByMap.entrySet()) {
            SortMeta sortMeta = entry.getValue();
            if (sortMeta.isHeaderRow()) continue;
            Integer index = sortKeysIndexes.get(entry.getKey());
            if (index != null) {
                sortMeta.setOrder(SortOrder.of(sortOrders[index]));
                sortMeta.setPriority(index);
                continue;
            }
            sortMeta.setOrder(SortOrder.UNSORTED);
            sortMeta.setPriority(SortMeta.MIN_PRIORITY);
        }
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        Map<String, SortMeta> sortMeta;
        table.setFirst(0);
        if (!table.loadLazyDataIfEnabled()) {
            if (table.isFullUpdateRequest(context)) {
                table.setValue(null);
            }
            this.sort(context, table);
            if (table.isPaginator() && ComponentUtils.isRequestSource((UIComponent)table, context)) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", table.getRowCount());
            }
            if (table.isFilteringCurrentlyActive()) {
                if (table.isFullUpdateRequest(context)) {
                    DataTableFeatures.filterFeature().filter(context, table);
                } else {
                    table.setFilteredValue(this.resolveList(table.getValue()));
                }
            }
        }
        context.getApplication().publishEvent(context, PostSortEvent.class, (Object)table);
        if (!table.isFullUpdateRequest(context)) {
            renderer.encodeTbody(context, table, true);
        }
        if (table.isMultiViewState() && !(sortMeta = table.getSortByAsMap()).isEmpty()) {
            DataTableState ts = table.getMultiViewState(true);
            ts.setSortBy(sortMeta);
            if (table.isPaginator()) {
                ts.setFirst(table.getFirst());
                ts.setRows(table.getRows());
            }
        }
    }

    public void sort(FacesContext context, DataTable table) {
        Object value = table.getValue();
        if (value == null) {
            return;
        }
        List list = this.resolveList(value);
        String var = table.getVar();
        Object varBackup = context.getExternalContext().getRequestMap().get(var);
        list.sort(SortTableComparator.comparingSortByVE(context, table));
        if (varBackup == null) {
            context.getExternalContext().getRequestMap().remove(var);
        } else {
            context.getExternalContext().getRequestMap().put(var, varBackup);
        }
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return this.isSortRequest(context, table);
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isSortRequest(context, table);
    }

    protected <T> List<T> resolveList(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof ListDataModel) {
            return (List)((ListDataModel)value).getWrappedData();
        }
        throw new FacesException(String.format("Data type should be java.util.List or %s instance to be sortable.", ListDataModel.class.getName()));
    }
}

