/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dataview;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.model.DataModel;
import org.primefaces.PrimeFaces;
import org.primefaces.component.dataview.DataViewBase;
import org.primefaces.component.dataview.DataViewGridItem;
import org.primefaces.component.dataview.DataViewListItem;
import org.primefaces.component.dataview.DataViewState;
import org.primefaces.event.data.PageEvent;
import org.primefaces.model.LazyDataModel;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="touch/touchswipe.js")})
public class DataView
extends DataViewBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataView";
    public static final String DATAVIEW_CLASS = "ui-dataview ui-widget";
    public static final String LIST_LAYOUT_CLASS = "ui-dataview-list";
    public static final String GRID_LAYOUT_CLASS = "ui-dataview-grid";
    public static final String HEADER_CLASS = "ui-dataview-header ui-widget-header ui-helper-clearfix";
    public static final String FOOTER_CLASS = "ui-dataview-footer ui-widget-header";
    public static final String CONTENT_CLASS = "ui-dataview-content ui-widget-content";
    public static final String BUTTON_CONTAINER_CLASS = "ui-dataview-layout-options ui-selectonebutton ui-buttonset";
    public static final String BUTTON_CLASS = "ui-button ui-button-icon-only ui-state-default";
    public static final String LIST_LAYOUT_CONTAINER_CLASS = "ui-dataview-list-container";
    public static final String ROW_CLASS = "ui-dataview-row";
    public static final String GRID_LAYOUT_ROW_CLASS = "ui-dataview-row";
    public static final String GRID_LAYOUT_COLUMN_CLASS = "ui-dataview-column";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("page", PageEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private DataViewGridItem gridItem;
    private DataViewListItem listItem;

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isLayoutRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_layout");
    }

    @Override
    public boolean isPaginationRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_pagination");
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            if ("page".equals(eventName)) {
                AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
                String clientId = this.getClientId(context);
                int rows = this.getRowsToRender();
                int first = Integer.parseInt((String)params.get(clientId + "_first"));
                int page = rows > 0 ? first / rows : 0;
                String rowsPerPageParam = (String)params.get(clientId + "_rows");
                Integer rowsPerPage = LangUtils.isNotBlank(rowsPerPageParam) ? Integer.valueOf(Integer.parseInt(rowsPerPageParam)) : null;
                PageEvent pageEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page, rowsPerPage);
                pageEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)pageEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    public DataViewGridItem getGridItem() {
        return this.gridItem;
    }

    public DataViewListItem getListItem() {
        return this.listItem;
    }

    public void findViewItems() {
        for (UIComponent kid : this.getChildren()) {
            if (!kid.isRendered()) continue;
            if (kid instanceof DataViewListItem) {
                this.listItem = (DataViewListItem)kid;
                continue;
            }
            if (!(kid instanceof DataViewGridItem)) continue;
            this.gridItem = (DataViewGridItem)kid;
        }
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model instanceof LazyDataModel) {
            LazyDataModel lazyModel = (LazyDataModel)model;
            if (this.getFirst() > 0) {
                lazyModel.setRowCount(lazyModel.count(Collections.emptyMap()));
                this.calculateFirst();
            }
            List data = lazyModel.load(this.getFirst(), this.getRows(), Collections.emptyMap(), Collections.emptyMap());
            lazyModel.calculateRowCount(data, Collections.emptyMap(), this.getFirst(), this.getRows());
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (ComponentUtils.isRequestSource((UIComponent)this, this.getFacesContext()) && this.isPaginator()) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        this.gridItem = null;
        this.listItem = null;
        return super.saveState(context);
    }

    public void reset() {
        this.setFirst(0);
        this.resetRows();
        this.setLayout(null);
    }

    @Override
    public void resetMultiViewState() {
        this.reset();
    }

    @Override
    public void restoreMultiViewState() {
        DataViewState viewState = this.getMultiViewState(false);
        if (viewState != null) {
            if (LangUtils.isNotEmpty(viewState.getLayout())) {
                this.setLayout(viewState.getLayout());
            }
            if (this.isPaginator()) {
                this.setFirst(viewState.getFirst());
                int rows = viewState.getRows() == 0 ? this.getRows() : viewState.getRows();
                this.setRows(rows);
            }
        }
    }

    @Override
    public DataViewState getMultiViewState(boolean create) {
        FacesContext fc = this.getFacesContext();
        String viewId = fc.getViewRoot().getViewId();
        return PrimeFaces.current().multiViewState().get(viewId, this.getClientId(fc), create, DataViewState::new);
    }
}

