/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.diagram;

import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.diagram.DiagramBase;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.diagram.ConnectEvent;
import org.primefaces.event.diagram.ConnectionChangeEvent;
import org.primefaces.event.diagram.DisconnectEvent;
import org.primefaces.event.diagram.PositionChangeEvent;
import org.primefaces.model.diagram.DiagramModel;
import org.primefaces.model.diagram.Element;
import org.primefaces.model.diagram.endpoint.EndPoint;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="diagram/diagram.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="diagram/diagram.js")})
public class Diagram
extends DiagramBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Diagram";
    public static final String CONTAINER_CLASS = "ui-diagram ui-widget";
    public static final String ELEMENT_CLASS = "ui-diagram-element";
    public static final String DRAGGABLE_ELEMENT_CLASS = "ui-diagram-draggable";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("connect", ConnectEvent.class).put("disconnect", DisconnectEvent.class).put("connectionChange", ConnectionChangeEvent.class).put("positionChange", PositionChangeEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isConnectRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_connect");
    }

    public boolean isDisconnectRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_disconnect");
    }

    public boolean isConnectionChangeRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_connectionChange");
    }

    public boolean isPositionChangeRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_positionChange");
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            DiagramModel model = (DiagramModel)this.getValue();
            if (model != null) {
                if ("connect".equals(eventName) || "disconnect".equals(eventName)) {
                    AbstractAjaxBehaviorEvent wrapperEvent = null;
                    Element sourceElement = model.findElement((String)params.get(clientId + "_sourceId"));
                    Element targetElement = model.findElement((String)params.get(clientId + "_targetId"));
                    EndPoint sourceEndPoint = model.findEndPoint(sourceElement, (String)params.get(clientId + "_sourceEndPointId"));
                    EndPoint targetEndPoint = model.findEndPoint(targetElement, (String)params.get(clientId + "_targetEndPointId"));
                    if ("connect".equals(eventName)) {
                        wrapperEvent = new ConnectEvent((UIComponent)this, behaviorEvent.getBehavior(), sourceElement, targetElement, sourceEndPoint, targetEndPoint);
                    } else if ("disconnect".equals(eventName)) {
                        wrapperEvent = new DisconnectEvent((UIComponent)this, behaviorEvent.getBehavior(), sourceElement, targetElement, sourceEndPoint, targetEndPoint);
                    }
                    if (wrapperEvent == null) {
                        throw new FacesException("Component " + this.getClass().getName() + " does not support event " + eventName + "!");
                    }
                    wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
                    super.queueEvent((FacesEvent)wrapperEvent);
                } else if ("connectionChange".equals(eventName)) {
                    Element originalSourceElement = model.findElement((String)params.get(clientId + "_originalSourceId"));
                    Element newSourceElement = model.findElement((String)params.get(clientId + "_newSourceId"));
                    Element originalTargetElement = model.findElement((String)params.get(clientId + "_originalTargetId"));
                    Element newTargetElement = model.findElement((String)params.get(clientId + "_newTargetId"));
                    EndPoint originalSourceEndPoint = model.findEndPoint(originalSourceElement, (String)params.get(clientId + "_originalSourceEndPointId"));
                    EndPoint newSourceEndPoint = model.findEndPoint(newSourceElement, (String)params.get(clientId + "_newSourceEndPointId"));
                    EndPoint originalTargetEndPoint = model.findEndPoint(originalTargetElement, (String)params.get(clientId + "_originalTargetEndPointId"));
                    EndPoint newTargetEndPoint = model.findEndPoint(newTargetElement, (String)params.get(clientId + "_newTargetEndPointId"));
                    ConnectionChangeEvent connectionChangeEvent = new ConnectionChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), originalSourceElement, newSourceElement, originalTargetElement, newTargetElement, originalSourceEndPoint, newSourceEndPoint, originalTargetEndPoint, newTargetEndPoint);
                    connectionChangeEvent.setPhaseId(behaviorEvent.getPhaseId());
                    super.queueEvent((FacesEvent)connectionChangeEvent);
                } else if ("positionChange".equals(eventName)) {
                    Element element = model.findElement((String)params.get(clientId + "_elementId"));
                    String[] position = ((String)params.get(clientId + "_position")).split(",");
                    PositionChangeEvent positionChangeEvent = new PositionChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), element, position[0] + "px", position[1] + "px");
                    positionChangeEvent.setPhaseId(behaviorEvent.getPhaseId());
                    super.queueEvent((FacesEvent)positionChangeEvent);
                }
            }
        } else {
            super.queueEvent(event);
        }
    }
}

