/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.feedreader;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.feedreader.FeedReader;
import org.primefaces.component.feedreader.RSSUtils;
import org.primefaces.model.feedreader.FeedItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FacetUtils;

public class FeedReaderRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        block3: {
            FeedReader reader = (FeedReader)component;
            try {
                Map requestMap = context.getExternalContext().getRequestMap();
                String var = reader.getVar();
                int size = reader.getSize();
                String url = reader.getValue();
                List<FeedItem> entries = RSSUtils.parse(url, size, reader.isPodcast());
                for (FeedItem item : entries) {
                    requestMap.put(var, item);
                    this.renderChildren(context, (UIComponent)reader);
                }
                requestMap.remove(var);
            }
            catch (Exception e) {
                this.logDevelopmentWarning(context, (Object)this, String.format("Unexpected RSS error: %s", e.getMessage()));
                UIComponent errorFacet = reader.getFacet("error");
                if (!FacetUtils.shouldRenderFacet(errorFacet)) break block3;
                errorFacet.encodeAll(context);
            }
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

