/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.feedreader;

import com.apptasticsoftware.rssreader.Item;
import com.apptasticsoftware.rssreader.RssReader;
import com.apptasticsoftware.rssreader.module.itunes.ItunesItem;
import com.apptasticsoftware.rssreader.module.itunes.ItunesRssReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.primefaces.model.feedreader.FeedItem;

public class RSSUtils {
    private RSSUtils() {
    }

    public static List<FeedItem> parse(Object input, int size, boolean isPodcast) throws IOException {
        Object reader = isPodcast ? new ItunesRssReader() : new RssReader();
        if (input instanceof String) {
            return RSSUtils.convert(reader.read((String)input).limit(size).collect(Collectors.toList()));
        }
        return RSSUtils.convert(reader.read((InputStream)input).limit(size).collect(Collectors.toList()));
    }

    private static List<FeedItem> convert(List<Item> items) {
        ArrayList<FeedItem> results = new ArrayList<FeedItem>(items.size());
        for (Item item : items) {
            FeedItem fi = new FeedItem();
            fi.setAuthor(item.getAuthor().orElse(""));
            fi.getCategories().addAll(item.getCategories());
            fi.setComments(item.getComments().orElse(""));
            fi.setDescription(item.getDescription().orElse(""));
            fi.setGuid(item.getGuid().orElse(""));
            fi.setIsPermaLink(item.getIsPermaLink().orElse(Boolean.FALSE));
            fi.setLink(item.getLink().orElse(""));
            fi.setPubDate(item.getPubDate().orElse(""));
            fi.setTitle(item.getTitle().orElse(""));
            if (item instanceof ItunesItem) {
                ItunesItem itunes = (ItunesItem)item;
                fi.setItunesBlock(itunes.isItunesBlock());
                fi.setItunesDuration(itunes.getItunesDuration().orElse(""));
                fi.setItunesEpisode(itunes.getItunesEpisode().orElse(0));
                fi.setItunesEpisodeType(itunes.getItunesEpisodeType().orElse(""));
                fi.setItunesExplicit(itunes.isItunesExplicit());
                fi.setItunesImage(itunes.getItunesImage().orElse(""));
                fi.setItunesKeywords(itunes.getItunesKeywords().orElse(""));
                fi.setItunesSeason(itunes.getItunesSeason().orElse(0));
                fi.setItunesSubtitle(itunes.getItunesSubtitle().orElse(""));
                fi.setItunesSummary(itunes.getItunesSummary().orElse(""));
                fi.setItunesTitle(itunes.getItunesTitle().orElse(""));
            }
            results.add(fi);
        }
        return results;
    }
}

