/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputnumber;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.inputnumber.InputNumber;
import org.primefaces.component.inputnumber.InputNumberBase;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class InputNumberRenderer
extends InputRenderer {
    private static final BigDecimal DEFAULT_MIN_VALUE = new BigDecimal("-10000000000000");
    private static final BigDecimal DEFAULT_MAX_VALUE = new BigDecimal("10000000000000");

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return ComponentUtils.getConvertedValue(context, component, submittedValue);
    }

    public void decode(FacesContext context, UIComponent component) {
        InputNumber inputNumber = (InputNumber)component;
        if (!this.shouldDecode((UIInput)inputNumber)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputNumber);
        String inputId = inputNumber.getClientId(context) + "_hinput";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue == null) {
            return;
        }
        try {
            if (LangUtils.isBlank(submittedValue)) {
                Class<?> type = this.getTypeFromValueExpression(context, inputNumber);
                if (type != null && type.isPrimitive() && LangUtils.isNotBlank(inputNumber.getMinValue())) {
                    submittedValue = String.valueOf(new BigDecimal(inputNumber.getMinValue()).doubleValue());
                } else if (type != null && type.isPrimitive() && LangUtils.isNotBlank(inputNumber.getMaxValue())) {
                    submittedValue = String.valueOf(new BigDecimal(inputNumber.getMaxValue()).doubleValue());
                }
            } else {
                BigDecimal value = new BigDecimal(submittedValue);
                submittedValue = this.coerceValueInRange(value, inputNumber).toString();
            }
        }
        catch (NumberFormatException ex) {
            throw new FacesException("Invalid number", (Throwable)ex);
        }
        inputNumber.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputNumber inputNumber = (InputNumber)component;
        Object value = inputNumber.getValue();
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputNumber, value);
        if (this.isValueBlank(valueToRender)) {
            valueToRender = "";
        } else {
            BigDecimal decimalToRender;
            try {
                decimalToRender = new BigDecimal(valueToRender);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error converting  [" + valueToRender + "] to a decimal value;", e);
            }
            valueToRender = this.formatForPlugin(this.coerceValueInRange(decimalToRender, inputNumber));
        }
        this.encodeMarkup(context, inputNumber, value, valueToRender);
        this.encodeScript(context, inputNumber, value, valueToRender);
    }

    protected void encodeMarkup(FacesContext context, InputNumber inputNumber, Object value, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputNumber.getClientId(context);
        Object styleClass = inputNumber.getStyleClass();
        styleClass = styleClass == null ? "ui-inputnumber ui-widget" : "ui-inputnumber ui-widget " + (String)styleClass;
        styleClass = inputNumber.isValid() ? styleClass : (String)styleClass + " ui-state-error";
        writer.startElement("span", (UIComponent)inputNumber);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", styleClass, "styleClass");
        if (inputNumber.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputNumber.getStyle(), "style");
        }
        this.encodeInput(context, inputNumber, clientId, valueToRender);
        this.encodeHiddenInput(context, inputNumber, clientId, valueToRender);
        writer.endElement("span");
    }

    protected void encodeHiddenInput(FacesContext context, InputNumber inputNumber, String clientId, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_hinput";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)valueToRender, null);
        if (inputNumber.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)inputNumber.getOnchange(), null);
        }
        if (inputNumber.getOnkeydown() != null) {
            writer.writeAttribute("onkeydown", (Object)inputNumber.getOnkeydown(), null);
        }
        if (inputNumber.getOnkeyup() != null) {
            writer.writeAttribute("onkeyup", (Object)inputNumber.getOnkeyup(), null);
        }
        this.renderValidationMetadata(context, (EditableValueHolder)inputNumber, new ClientValidator[0]);
        writer.endElement("input");
    }

    protected void encodeInput(FacesContext context, InputNumber inputNumber, String clientId, String valueToRender) throws IOException {
        String inputStyle;
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        String style = inputStyle = inputNumber.getInputStyle();
        String styleClass = this.createStyleClass((UIInput)inputNumber, InputNumberBase.PropertyKeys.inputStyleClass.name(), "ui-inputfield ui-inputtext ui-widget ui-state-default");
        String inputMode = inputNumber.getInputmode();
        if (inputMode == null) {
            boolean isIntegral = this.isIntegral(context, inputNumber, inputNumber.getValue());
            String decimalPlaces = this.getDecimalPlaces(isIntegral, inputNumber);
            inputMode = "0".equals(decimalPlaces) ? "numeric" : "decimal";
            inputNumber.setInputmode(inputMode);
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)inputNumber.getType(), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("value", (Object)valueToRender, null);
        if (!this.isValueBlank(style)) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        this.renderAccessibilityAttributes(context, (UIInput)inputNumber);
        this.renderPassThruAttributes(context, (UIComponent)inputNumber, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputNumber, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)inputNumber, new ClientValidator[0]);
        writer.endElement("input");
    }

    protected void encodeScript(FacesContext context, InputNumber inputNumber, Object value, String valueToRender) throws IOException {
        String emptyValue = this.isValueBlank(inputNumber.getEmptyValue()) || "empty".equalsIgnoreCase(inputNumber.getEmptyValue()) ? "null" : inputNumber.getEmptyValue();
        String digitGroupSeparator = this.isValueBlank(inputNumber.getThousandSeparator()) ? "" : inputNumber.getThousandSeparator();
        String decimalSeparator = this.isValueBlank(inputNumber.getDecimalSeparator()) ? "." : inputNumber.getDecimalSeparator();
        boolean isIntegral = this.isIntegral(context, inputNumber, value);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init(InputNumber.class.getSimpleName(), inputNumber);
        wb.attr("disabled", inputNumber.isDisabled()).attr("valueToRender", valueToRender).attr("decimalCharacter", decimalSeparator, ".").attr("decimalCharacterAlternative", inputNumber.getDecimalSeparatorAlternative(), null).attr("digitGroupSeparator", digitGroupSeparator, ",").attr("currencySymbol", inputNumber.getSymbol()).attr("currencySymbolPlacement", inputNumber.getSymbolPosition(), "p").attr("negativePositiveSignPlacement", inputNumber.getSignPosition(), null).attr("minimumValue", this.getMinimum(isIntegral, inputNumber)).attr("maximumValue", this.getMaximum(isIntegral, inputNumber)).attr("decimalPlaces", this.getDecimalPlaces(isIntegral, inputNumber)).attr("emptyInputBehavior", emptyValue, "focus").attr("leadingZero", inputNumber.getLeadingZero(), "deny").attr("allowDecimalPadding", inputNumber.getPadControl(), "true").attr("modifyValueOnWheel", inputNumber.isModifyValueOnWheel(), true).attr("modifyValueOnUpDownArrow", inputNumber.isModifyValueOnUpDownArrow(), true).attr("roundingMethod", inputNumber.getRoundMethod(), "S").attr("caretPositionOnFocus", inputNumber.getCaretPositionOnFocus(), null).attr("selectOnFocus", inputNumber.isSelectOnFocus(), true).attr("showWarnings", false, true);
        wb.finish();
    }

    @Override
    protected String getHighlighter() {
        return "inputnumber";
    }

    private BigDecimal getEffectiveMinValue(InputNumber inputNumber) {
        String minimumValue = inputNumber.getMinValue();
        if (minimumValue == null) {
            return DEFAULT_MIN_VALUE;
        }
        try {
            return new BigDecimal(minimumValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting  [" + minimumValue + "] to a decimal value for minValue", e);
        }
    }

    private BigDecimal getEffectiveMaxValue(InputNumber inputNumber) {
        String maximumValue = inputNumber.getMaxValue();
        if (maximumValue == null) {
            return DEFAULT_MAX_VALUE;
        }
        try {
            return new BigDecimal(maximumValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting  [" + maximumValue + "] to a decimal value for maxValue", e);
        }
    }

    private BigDecimal coerceValueInRange(BigDecimal value, InputNumber inputNumber) {
        return this.coerceValueInRange(value, this.getEffectiveMinValue(inputNumber), this.getEffectiveMaxValue(inputNumber));
    }

    private BigDecimal coerceValueInRange(BigDecimal value, BigDecimal effectiveMinValue, BigDecimal effectiveMaxValue) {
        if (value.compareTo(effectiveMinValue) < 0) {
            return effectiveMinValue;
        }
        if (value.compareTo(effectiveMaxValue) > 0) {
            return effectiveMaxValue;
        }
        return value;
    }

    private String formatForPlugin(String valueToRender) {
        if (valueToRender == null) {
            return null;
        }
        if (this.isValueBlank(valueToRender)) {
            return "";
        }
        try {
            BigDecimal objectToRender = new BigDecimal(valueToRender);
            return this.formatForPlugin(objectToRender);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting  [" + valueToRender + "] to a decimal value;", e);
        }
    }

    private String formatForPlugin(BigDecimal valueToRender) {
        return valueToRender.toPlainString();
    }

    private String getDecimalPlaces(boolean isIntegral, InputNumber inputNumber) {
        if (inputNumber.getDecimalPlaces() != null) {
            return inputNumber.getDecimalPlaces();
        }
        if (isIntegral) {
            return "0";
        }
        return "2";
    }

    private String getMinimum(boolean isIntegral, InputNumber inputNumber) {
        String minimum = inputNumber.getMinValue();
        if (isIntegral && "0.0000001".equals(minimum)) {
            minimum = "0";
        }
        return this.formatForPlugin(minimum);
    }

    private String getMaximum(boolean isIntegral, InputNumber inputNumber) {
        String maximum = inputNumber.getMaxValue();
        if (isIntegral && "-0.0000001".equals(maximum)) {
            maximum = "0";
        }
        return this.formatForPlugin(maximum);
    }

    protected boolean isIntegral(FacesContext context, InputNumber inputNumber, Object value) {
        if (value != null) {
            return value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof BigInteger || value instanceof Byte;
        }
        Class<Number> type = this.getTypeFromValueExpression(context, inputNumber);
        if (type == null || type == Number.class) {
            return false;
        }
        return type.isAssignableFrom(Long.class) || type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Short.class) || type.isAssignableFrom(BigInteger.class) || type.isAssignableFrom(Byte.class);
    }

    public Class<?> getTypeFromValueExpression(FacesContext context, InputNumber inputNumber) {
        ValueExpression valueExpression = inputNumber.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        try {
            return valueExpression.getType(context.getELContext());
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }
}

