/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.megamenu;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.megamenu.MegaMenu;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.model.menu.MenuColumn;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.Separator;
import org.primefaces.model.menu.Submenu;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class MegaMenuRenderer
extends BaseMenuRenderer {
    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        MegaMenu menu = (MegaMenu)abstractMenu;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("MegaMenu", menu).attr("tabIndex", menu.getTabindex(), "0").attr("autoDisplay", menu.isAutoDisplay()).attr("delay", menu.getDelay()).attr("activeIndex", menu.getActiveIndex(), Integer.MIN_VALUE);
        wb.finish();
    }

    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MegaMenu menu = (MegaMenu)abstractMenu;
        boolean vertical = menu.getOrientation().equals("vertical");
        String clientId = menu.getClientId(context);
        String style = menu.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-menu ui-menubar ui-megamenu ui-widget ui-widget-content ui-helper-clearfix").add(menu.getStyleClass()).add(vertical, "ui-megamenu-vertical").add(ComponentUtils.isRTL(context, abstractMenu), "ui-menu-rtl").build();
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.writeAttribute("tabindex", (Object)"-1", "tabindex");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("ul", null);
        writer.writeAttribute("role", (Object)"menubar", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        this.encodeFacet(context, menu, "start", "ui-menuitem ui-menubar-start ui-widget");
        if (menu.getElementsCount() > 0) {
            this.encodeRootItems(context, menu);
        }
        this.encodeFacet(context, menu, "options", "ui-menuitem ui-menubar-options ui-widget");
        this.encodeFacet(context, menu, "end", "ui-menuitem ui-menubar-end ui-widget");
        writer.endElement("ul");
        writer.endElement("div");
    }

    @Override
    protected void encodePlaceholder(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)menu.getClientId(context), "id");
        writer.writeAttribute("class", (Object)"ui-megamenu-placeholder", "styleClass");
        writer.endElement("div");
    }

    protected void encodeRootItems(FacesContext context, MegaMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<MenuElement> elements = menu.getElements();
        for (MenuElement element : elements) {
            if (!element.isRendered()) continue;
            if (element instanceof MenuItem) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget", null);
                writer.writeAttribute("role", (Object)"none", null);
                this.encodeMenuItem(context, menu, (MenuItem)element, "-1");
                writer.endElement("li");
                continue;
            }
            if (element instanceof Submenu) {
                this.encodeRootSubmenu(context, menu, (Submenu)element);
                continue;
            }
            if (!(element instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)element);
        }
    }

    protected void encodeRootSubmenu(FacesContext context, MegaMenu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean isRtl = ComponentUtils.isRTL(context, menu);
        boolean isVertical = menu.getOrientation().equals("vertical");
        String style = submenu.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-widget ui-menuitem ui-menu-parent").add(submenu.getStyleClass()).build();
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (LangUtils.isNotEmpty(style)) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("role", (Object)"none", null);
        writer.startElement("a", null);
        writer.writeAttribute("role", (Object)"menuitem", null);
        writer.writeAttribute("aria-haspopup", (Object)"true", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-link ui-submenu-link", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (isRtl) {
            this.encodeSubmenuIcon(context, submenu, isRtl, isVertical);
            this.encodeMenuLabel(context, submenu);
            this.encodeMenuIcon(context, submenu);
        } else {
            this.encodeMenuIcon(context, submenu);
            this.encodeMenuLabel(context, submenu);
            this.encodeSubmenuIcon(context, submenu, isRtl, isVertical);
        }
        writer.endElement("a");
        if (submenu.getElementsCount() > 0) {
            List<MenuElement> submenuElements = submenu.getElements();
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-menu-list ui-helper-clearfix ui-menu-child ui-shadow", null);
            writer.writeAttribute("role", (Object)"menu", null);
            writer.startElement("table", null);
            writer.writeAttribute("role", (Object)"presentation", null);
            writer.startElement("tbody", null);
            writer.startElement("tr", null);
            for (MenuElement submenuElement : submenuElements) {
                if (!submenuElement.isRendered() || !(submenuElement instanceof MenuColumn)) continue;
                this.encodeColumn(context, menu, (MenuColumn)submenuElement);
            }
            writer.endElement("tr");
            writer.endElement("tbody");
            writer.endElement("table");
            writer.endElement("ul");
        }
        writer.endElement("li");
    }

    protected void encodeColumn(FacesContext context, MegaMenu menu, MenuColumn column) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        if (column.getStyle() != null) {
            writer.writeAttribute("style", (Object)column.getStyle(), null);
        }
        if (column.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)column.getStyleClass(), null);
        }
        if (column.getElementsCount() > 0) {
            List<MenuElement> columnElements = column.getElements();
            for (MenuElement element : columnElements) {
                if (!element.isRendered()) continue;
                if (element instanceof Submenu) {
                    this.encodeDescendantSubmenu(context, menu, (Submenu)element);
                    continue;
                }
                if (!(element instanceof Separator)) continue;
                this.encodeSubmenuSeparator(context, (Separator)element);
            }
        }
        writer.endElement("td");
    }

    protected void encodeDescendantSubmenu(FacesContext context, MegaMenu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        String style = submenu.getStyle();
        Object styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-widget-header" : "ui-widget-header " + (String)styleClass;
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        writer.writeAttribute("role", (Object)"menu", null);
        writer.startElement("li", null);
        writer.writeAttribute("class", styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("span", null);
        if (LangUtils.isNotEmpty(label)) {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("span");
        writer.endElement("li");
        if (submenu.getElementsCount() > 0) {
            List<MenuElement> submenuElements = submenu.getElements();
            for (MenuElement submenuElement : submenuElements) {
                if (!submenuElement.isRendered()) continue;
                if (submenuElement instanceof MenuItem) {
                    writer.startElement("li", null);
                    writer.writeAttribute("class", (Object)"ui-menuitem ui-widget", null);
                    writer.writeAttribute("role", (Object)"none", null);
                    this.encodeMenuItem(context, menu, (MenuItem)submenuElement, "-1");
                    writer.endElement("li");
                    continue;
                }
                if (!(submenuElement instanceof Separator)) continue;
                this.encodeSeparator(context, (Separator)submenuElement);
            }
        }
        writer.endElement("ul");
    }

    protected void encodeSubmenuSeparator(FacesContext context, Separator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String title = separator.getTitle();
        String style = separator.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-separator ui-state-default").add(separator.getStyleClass()).build();
        writer.startElement("hr", null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (LangUtils.isNotEmpty(title)) {
            writer.writeAttribute("title", (Object)title, "title");
        }
        if (LangUtils.isNotEmpty(style)) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.endElement("hr");
    }
}

