/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.faces.component.UIPanel;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.MenuItemAware;
import org.primefaces.component.api.RTLAware;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuModel;

public abstract class AbstractMenu
extends UIPanel
implements MenuItemAware,
RTLAware {
    public static final String LIST_CLASS = "ui-menu-list ui-helper-reset";
    public static final String MENU_RTL_CLASS = "ui-menu-rtl";
    public static final String MENUITEM_CLASS = "ui-menuitem ui-widget";
    public static final String MENUITEM_LINK_CLASS = "ui-menuitem-link";
    public static final String MENUITEM_TEXT_CLASS = "ui-menuitem-text";
    public static final String MENUITEM_ICON_CLASS = "ui-menuitem-icon ui-icon";
    public static final String TIERED_SUBMENU_CLASS = "ui-widget ui-menuitem ui-menu-parent";
    public static final String TIERED_CHILD_SUBMENU_CLASS = "ui-widget-content ui-menu-list ui-helper-clearfix ui-menu-child ui-shadow";
    public static final String SUBMENU_RIGHT_ICON_CLASS = "ui-icon ui-icon-triangle-1-e";
    public static final String SUBMENU_LEFT_ICON_CLASS = "ui-icon ui-icon-triangle-1-w";
    public static final String SUBMENU_DOWN_ICON_CLASS = "ui-icon ui-icon-triangle-1-s";
    public static final String SUBMENU_LINK_CLASS = "ui-menuitem-link ui-submenu-link";
    public static final String OPTIONS_CLASS = "ui-menuitem ui-menubar-options ui-widget";
    public static final String START_CLASS = "ui-menuitem ui-menubar-start ui-widget";
    public static final String END_CLASS = "ui-menuitem ui-menubar-end ui-widget";

    public String getTabindex() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tabindex), (Object)"0");
    }

    public void setTabindex(String tabindex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tabindex), (Object)tabindex);
    }

    public boolean isAutoDisplay() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.autoDisplay), (Object)true);
    }

    public void setAutoDisplay(boolean autoDisplay) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.autoDisplay), (Object)autoDisplay);
    }

    public int getShowDelay() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showDelay), (Object)0);
    }

    public void setShowDelay(int showDelay) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showDelay), (Object)showDelay);
    }

    public int getHideDelay() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.hideDelay), (Object)0);
    }

    public void setHideDelay(int hideDelay) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.hideDelay), (Object)hideDelay);
    }

    public String getToggleEvent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.toggleEvent), null);
    }

    public void setToggleEvent(String toggleEvent) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.toggleEvent), (Object)toggleEvent);
    }

    @Override
    public String getDir() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dir), (Object)"ltr");
    }

    public void setDir(String dir) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dir), (Object)dir);
    }

    @Override
    public List<MenuElement> getElements() {
        MenuModel model = this.getModel();
        if (model != null) {
            return model.getElements();
        }
        return this.getChildren().stream().filter(MenuElement.class::isInstance).map(MenuElement.class::cast).collect(Collectors.toList());
    }

    public int getElementsCount() {
        List<MenuElement> elements = this.getElements();
        return elements == null ? 0 : elements.size();
    }

    public abstract MenuModel getModel();

    public boolean isDynamic() {
        return this.getValueExpression("model") != null;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        this.broadcastMenuActionEvent(event, this.getFacesContext(), x$0 -> super.broadcast(x$0));
    }

    public static enum PropertyKeys {
        tabindex,
        autoDisplay,
        showDelay,
        hideDelay,
        toggleEvent,
        dir;

    }
}

