/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menubutton;

import java.io.IOException;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menubutton.MenuButton;
import org.primefaces.component.tieredmenu.TieredMenuRenderer;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class MenuButtonRenderer
extends TieredMenuRenderer {
    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        Object styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-menubutton ui-widget" : "ui-menubutton ui-widget " + (String)styleClass;
        boolean disabled = button.isDisabled();
        writer.startElement("span", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleClass, "class");
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), "style");
        }
        if (button.getTitle() != null) {
            writer.writeAttribute("title", (Object)button.getTitle(), "title");
        }
        String menuId = clientId + "_menu";
        this.encodeButton(context, button, clientId + "_button", menuId, disabled);
        this.encodeMenu(context, button, menuId);
        writer.endElement("span");
    }

    @Override
    protected void encodePlaceholder(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)menu);
        writer.writeAttribute("id", (Object)menu.getClientId(context), "id");
        writer.writeAttribute("class", (Object)"ui-menubutton-placeholder", "styleClass");
        writer.endElement("span");
    }

    protected void encodeButton(FacesContext context, MenuButton button, String buttonId, String menuId, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean isIconLeft = button.getIconPos().equals("left");
        String value = button.getValue();
        String buttonClass = this.getStyleClassBuilder(context).add(button.getButtonStyleClass()).add(isIconLeft, "ui-button ui-widget ui-state-default ui-button-text-icon-left", "ui-button ui-widget ui-state-default ui-button-text-icon-right").add(this.isValueBlank(value), "ui-button ui-widget ui-state-default ui-button-icon-only").add(disabled, "ui-state-disabled").build();
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)buttonId, null);
        writer.writeAttribute("name", (Object)buttonId, null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)buttonClass, null);
        writer.writeAttribute("aria-label", (Object)button.getAriaLabel(), "ariaLabel");
        writer.writeAttribute("aria-expanded", (Object)"false", null);
        writer.writeAttribute("aria-haspopup", (Object)"true", null);
        writer.writeAttribute("aria-controls", (Object)menuId, null);
        if (LangUtils.isNotEmpty(button.getButtonStyle())) {
            writer.writeAttribute("style", (Object)button.getButtonStyle(), null);
        }
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        Object iconClass = this.isValueBlank(button.getIcon()) ? "ui-icon-triangle-1-s" : button.getIcon();
        String iconPosClass = isIconLeft ? "ui-button-icon-left ui-icon ui-c" : "ui-button-icon-right ui-icon ui-c";
        iconClass = iconPosClass + " " + (String)iconClass;
        writer.startElement("span", null);
        writer.writeAttribute("class", iconClass, null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        this.renderButtonValue(writer, true, button.getValue(), button.getTitle(), button.getAriaLabel());
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeMenu(FacesContext context, MenuButton button, String menuId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object menuStyleClass = button.getMenuStyleClass();
        menuStyleClass = menuStyleClass == null ? "ui-menu ui-menu-dynamic ui-widget ui-widget-content ui-helper-clearfix ui-shadow" : "ui-menu ui-menu-dynamic ui-widget ui-widget-content ui-helper-clearfix ui-shadow " + (String)menuStyleClass;
        writer.startElement("div", null);
        if (!LangUtils.isEmpty(button.getMaxHeight())) {
            menuStyleClass = (String)menuStyleClass + " ui-menu-dynamic-maxheight";
            char lastChar = button.getMaxHeight().charAt(button.getMaxHeight().length() - 1);
            Object style = Character.isDigit(lastChar) ? button.getMaxHeight() + "px" : button.getMaxHeight();
            writer.writeAttribute("style", (Object)("max-height:" + (String)style), null);
        }
        writer.writeAttribute("id", (Object)menuId, null);
        writer.writeAttribute("class", menuStyleClass, "styleClass");
        writer.startElement("ul", null);
        writer.writeAttribute("role", (Object)"menubar", null);
        writer.writeAttribute("aria-orientation", (Object)"vertical", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", "styleClass");
        if (button.getElementsCount() > 0) {
            List<MenuElement> elements = button.getElements();
            this.encodeElements(context, button, elements);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        UIForm form = ComponentTraversalUtils.closestForm((UIComponent)button);
        if (form == null) {
            throw new FacesException("MenuButton : \"" + clientId + "\" must be inside a form element");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("MenuButton", button).attr("appendTo", SearchExpressionUtils.resolveOptionalClientIdForClientSide(context, (UIComponent)button, button.getAppendTo())).attr("collision", button.getCollision()).attr("autoDisplay", button.isAutoDisplay()).attr("toggleEvent", button.getToggleEvent(), null).attr("delay", button.getDelay()).attr("disableOnAjax", button.isDisableOnAjax(), true).attr("disabledAttr", button.isDisabled(), false).finish();
    }
}

