/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.message;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.message.Message;
import org.primefaces.component.message.MessageState;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.UINotificationRenderer;
import org.primefaces.util.CompositeUtils;
import org.primefaces.util.StyleClassBuilder;
import org.primefaces.util.WidgetBuilder;

public class MessageRenderer
extends UINotificationRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Message uiMessage = (Message)component;
        UIComponent target = SearchExpressionUtils.contextlessResolveComponent(context, (UIComponent)uiMessage, uiMessage.getFor());
        MessageState state = new MessageState();
        state.setTargetId(target.getClientId(context));
        state.setTooltipTargetId(this.getTooltipTargetId(target, context));
        if (!this.hasDisplayableMessage(uiMessage, target, context) && CompositeUtils.isComposite(target)) {
            ContextCallback callback = (fc, comp) -> {
                if (this.hasDisplayableMessage(uiMessage, comp, fc)) {
                    state.setTargetId(comp.getClientId(fc));
                    state.setTooltipTargetId(this.getTooltipTargetId(comp, fc));
                }
            };
            CompositeUtils.invokeOnDeepestEditableValueHolder(context, target, callback);
        }
        this.encodeMarkup(context, uiMessage, state.getTargetId());
        this.encodeScript(context, uiMessage, state.getTooltipTargetId());
    }

    protected void encodeMarkup(FacesContext context, Message uiMessage, String targetClientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String display = uiMessage.getDisplay();
        boolean iconOnly = "icon".equals(display);
        String style = uiMessage.getStyle();
        StyleClassBuilder styleClassBuilder = this.getStyleClassBuilder(context).add("ui-message", uiMessage.getStyleClass()).add("tooltip".equals(display), "ui-helper-hidden");
        Iterator msgs = context.getMessages(targetClientId);
        writer.startElement("div", (UIComponent)uiMessage);
        writer.writeAttribute("id", (Object)uiMessage.getClientId(context), null);
        writer.writeAttribute("role", (Object)"alert", null);
        writer.writeAttribute("aria-atomic", (Object)"true", null);
        writer.writeAttribute("aria-live", (Object)"polite", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (PrimeApplicationContext.getCurrentInstance(context).getConfig().isClientSideValidationEnabled()) {
            writer.writeAttribute("data-display", (Object)display, null);
            writer.writeAttribute("data-target", (Object)targetClientId, null);
            writer.writeAttribute("data-redisplay", (Object)String.valueOf(uiMessage.isRedisplay()), null);
        }
        boolean hasMessage = false;
        while (msgs.hasNext()) {
            String severityName;
            FacesMessage msg = (FacesMessage)msgs.next();
            if (!this.shouldRender(uiMessage, msg, severityName = this.getSeverityName(msg))) continue;
            styleClassBuilder.add("ui-message-" + severityName + " ui-widget");
            styleClassBuilder.add(iconOnly, "ui-message-icon-only ui-helper-clearfix");
            writer.writeAttribute("class", (Object)styleClassBuilder.build(), null);
            writer.startElement("div", null);
            if (!"text".equals(display)) {
                this.encodeIcon(writer, severityName, msg.getDetail(), iconOnly);
            }
            if (!iconOnly) {
                String summary = msg.getSummary();
                String detail = msg.getDetail();
                if (uiMessage.isSkipDetailIfEqualsSummary() && Objects.equals(summary, detail)) {
                    detail = "";
                }
                if (uiMessage.isShowSummary()) {
                    this.encodeText(context, uiMessage, summary, severityName + "-summary");
                }
                if (uiMessage.isShowDetail()) {
                    this.encodeText(context, uiMessage, detail, severityName + "-detail");
                }
            }
            writer.endElement("div");
            msg.rendered();
            hasMessage = true;
            break;
        }
        if (!hasMessage) {
            writer.writeAttribute("class", (Object)styleClassBuilder.build(), null);
        }
        writer.endElement("div");
    }

    protected void encodeText(FacesContext context, Message uiMessage, String text, String severity) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity), null);
        writer.writeAttribute("id", (Object)(uiMessage.getClientId(context) + "_" + severity), null);
        if (uiMessage.isEscape()) {
            writer.writeText((Object)text, null);
        } else {
            writer.write(text);
        }
        writer.endElement("span");
    }

    protected void encodeIcon(ResponseWriter writer, String severity, String title, boolean iconOnly) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity + "-icon"), null);
        if (iconOnly) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, Message uiMessage, String targetClientId) throws IOException {
        boolean tooltip = "tooltip".equals(uiMessage.getDisplay());
        if (tooltip || uiMessage.isShowDetail()) {
            WidgetBuilder wb = this.getWidgetBuilder(context);
            wb.init("Message", uiMessage).attr("target", targetClientId).attr("tooltip", tooltip, false).finish();
        }
    }
}

