/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.speeddial;

import java.io.IOException;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.badge.BadgeRenderer;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.speeddial.SpeedDial;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class SpeedDialRenderer
extends BaseMenuRenderer {
    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        SpeedDial speedDial = (SpeedDial)abstractMenu;
        String clientId = speedDial.getClientId(context);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        this.encodeContainer(context, speedDial);
        if (speedDial.isMask()) {
            this.encodeMask(context, speedDial);
        }
        writer.endElement("div");
    }

    @Override
    protected void encodePlaceholder(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)menu.getClientId(context), "id");
        writer.writeAttribute("class", (Object)"ui-speedidal-placeholder", "styleClass");
        writer.endElement("div");
    }

    protected void encodeContainer(FacesContext context, SpeedDial speedDial) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-speeddial ui-widget").add("ui-speeddial-" + speedDial.getType()).add(!"circle".equals(speedDial.getType()), "ui-speeddial-direction-" + speedDial.getDirection()).add(speedDial.isDisabled(), "ui-disabled").add(speedDial.getStyleClass()).build();
        String containerStyle = speedDial.getStyle();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, "class");
        if (containerStyle != null) {
            writer.writeAttribute("style", (Object)containerStyle, "style");
        }
        BadgeRenderer.encodeOverlayed(context, speedDial.getBadge(), this::encodeButton, speedDial);
        this.encodeList(context, speedDial);
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, SpeedDial speedDial) throws IOException {
        if (speedDial.getElementsCount() <= 0 || speedDial.getElements().stream().noneMatch(me -> this.shouldBeRendered(context, (MenuElement)me))) {
            return;
        }
        List<MenuElement> elements = speedDial.getElements();
        ResponseWriter writer = context.getResponseWriter();
        String listClass = this.getStyleClassBuilder(context).add("ui-speeddial-list").add(speedDial.getMaskStyleClass()).build();
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)listClass, "class");
        writer.writeAttribute("role", (Object)"menu", "role");
        for (MenuElement element : elements) {
            if (!element.isRendered() || !(element instanceof MenuItem)) continue;
            MenuItem menuItem = (MenuItem)element;
            String icon = menuItem.getIcon();
            Object value = menuItem.getValue();
            boolean disabled = menuItem.isDisabled();
            String title = menuItem.getTitle();
            String style = menuItem.getStyle();
            String rel = menuItem.getRel();
            String ariaLabel = menuItem.getAriaLabel();
            writer.startElement("li", null);
            writer.writeAttribute("role", (Object)"none", "role");
            writer.writeAttribute("class", (Object)"ui-speeddial-item", "class");
            writer.startElement("a", null);
            writer.writeAttribute("tabindex", (Object)-1, null);
            writer.writeAttribute("role", (Object)"menuitem", "role");
            if (this.shouldRenderId(menuItem)) {
                writer.writeAttribute("id", (Object)menuItem.getClientId(), null);
            }
            String styleClass = this.getStyleClassBuilder(context).add("ui-speeddial-action").add(disabled, "ui-disabled").build();
            writer.writeAttribute("class", (Object)styleClass, null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (title != null) {
                writer.writeAttribute("data-tooltip", (Object)title, null);
            }
            if (rel != null) {
                writer.writeAttribute("rel", (Object)rel, null);
            }
            if (LangUtils.isNotEmpty(ariaLabel)) {
                writer.writeAttribute("aria-label", (Object)ariaLabel, null);
            }
            if (disabled) {
                writer.writeAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)"return false;", null);
            } else {
                this.encodeOnClick(context, (UIComponent)speedDial, menuItem);
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)("ui-speeddial-action-icon " + icon), null);
                writer.writeAttribute("aria-hidden", (Object)"true", null);
                writer.endElement("span");
            }
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
            if (menuItem.shouldRenderChildren()) {
                this.renderChildren(context, (UIComponent)menuItem);
            } else if (value != null) {
                if (menuItem.isEscape()) {
                    writer.writeText(value, "value");
                } else {
                    writer.write(value.toString());
                }
            }
            writer.endElement("span");
            writer.endElement("a");
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    protected void encodeButton(FacesContext context, SpeedDial speedDial) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String buttonStyle = speedDial.getButtonStyle();
        String ariaLabel = speedDial.getAriaLabel();
        String title = speedDial.getTitle();
        boolean isDisabled = speedDial.isDisabled();
        String buttonStyleClass = this.getStyleClassBuilder(context).add("ui-button ui-widget ui-state-default ui-button-icon-only").add("ui-speeddial-button rounded-button").add(speedDial.isRotateAnimation(), "ui-speeddial-rotate").add(speedDial.getHideIcon() != null, "ui-speeddial-dual-icon").add(speedDial.getButtonStyleClass()).build();
        writer.startElement("button", (UIComponent)speedDial);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("class", (Object)buttonStyleClass, "class");
        if (LangUtils.isNotEmpty(ariaLabel)) {
            writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        }
        if (LangUtils.isNotEmpty(title)) {
            writer.writeAttribute("title", (Object)title, null);
        }
        if (buttonStyle != null) {
            writer.writeAttribute("style", (Object)buttonStyle, "style");
        }
        if (isDisabled) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + speedDial.getShowIcon()), null);
        writer.endElement("span");
        if (LangUtils.isNotEmpty(speedDial.getHideIcon())) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + speedDial.getHideIcon()), null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.writeText((Object)this.getIconOnlyButtonText(title, ariaLabel), null);
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeMask(FacesContext context, SpeedDial speedDial) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-speeddial-mask").add(speedDial.getMaskStyleClass()).build();
        String maskStyle = speedDial.getMaskStyle();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, "class");
        if (maskStyle != null) {
            writer.writeAttribute("style", (Object)maskStyle, "style");
        }
        writer.endElement("div");
    }

    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        SpeedDial speedDial = (SpeedDial)abstractMenu;
        String clientId = speedDial.getClientId(context);
        UIForm form = ComponentTraversalUtils.closestForm((UIComponent)speedDial);
        if (form == null) {
            throw new FacesException("SpeedDial : \"" + clientId + "\" must be inside a form element");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SpeedDial", speedDial).attr("visible", speedDial.isVisible(), false).attr("direction", speedDial.getDirection(), "up").attr("transitionDelay", speedDial.getTransitionDelay(), 30).attr("type", speedDial.getType(), "linear").attr("radius", speedDial.getRadius(), 0).attr("mask", speedDial.isMask(), false).attr("hideOnClickOutside", speedDial.isHideOnClickOutside(), true).attr("keepOpen", speedDial.isKeepOpen(), false).callback("onVisibleChange", "function(visible)", speedDial.getOnVisibleChange()).callback("onClick", "function(event)", speedDial.getOnClick()).callback("onShow", "function()", speedDial.getOnShow()).callback("onHide", "function()", speedDial.getOnHide());
        wb.finish();
    }

    @Override
    protected boolean shouldBeRendered(FacesContext context, AbstractMenu abstractMenu) {
        return true;
    }
}

