/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.spinner;

import java.io.IOException;
import java.math.BigInteger;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.spinner.Spinner;
import org.primefaces.component.spinner.SpinnerBase;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class SpinnerRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Spinner spinner = (Spinner)component;
        if (!this.shouldDecode((UIInput)spinner)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)spinner);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(spinner.getClientId(context) + "_input");
        if (LangUtils.isNotEmpty(submittedValue)) {
            String prefix = spinner.getPrefix();
            String suffix = spinner.getSuffix();
            if (prefix != null && submittedValue.startsWith(prefix)) {
                submittedValue = submittedValue.substring(prefix.length());
            }
            if (suffix != null && submittedValue.endsWith(suffix)) {
                submittedValue = submittedValue.substring(0, submittedValue.length() - suffix.length());
            }
            if (LangUtils.isNotEmpty(spinner.getThousandSeparator())) {
                submittedValue = submittedValue.replace(spinner.getThousandSeparator(), "");
            }
            if (LangUtils.isNotEmpty(spinner.getDecimalSeparator())) {
                submittedValue = submittedValue.replace(spinner.getDecimalSeparator(), ".");
            }
            try {
                double submittedNumber = Double.parseDouble(submittedValue);
                if (submittedNumber < spinner.getMin() || submittedNumber > spinner.getMax()) {
                    this.logDevelopmentWarning(context, (Object)this, String.format("Value is outside min/max range: %s", submittedValue));
                    return;
                }
            }
            catch (NumberFormatException e) {
                this.logDevelopmentWarning(context, (Object)this, String.format("Invalid number format: %s", submittedValue));
                return;
            }
        }
        spinner.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Spinner spinner = (Spinner)component;
        this.encodeMarkup(context, spinner);
        this.encodeScript(context, spinner);
    }

    protected void encodeScript(FacesContext context, Spinner spinner) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        Object value = spinner.getValue();
        String defaultDecimalPlaces = null;
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof BigInteger) {
            defaultDecimalPlaces = "0";
        }
        String decimalPlaces = this.isValueBlank(spinner.getDecimalPlaces()) ? defaultDecimalPlaces : spinner.getDecimalPlaces();
        wb.init("Spinner", spinner).attr("step", spinner.getStepFactor(), 1.0).attr("round", spinner.isRound(), false).attr("min", spinner.getMin(), Spinner.MIN_VALUE).attr("max", spinner.getMax(), Spinner.MAX_VALUE).attr("prefix", spinner.getPrefix(), null).attr("suffix", spinner.getSuffix(), null).attr("rotate", spinner.isRotate(), false).attr("decimalPlaces", decimalPlaces, null).attr("modifyValueOnWheel", spinner.isModifyValueOnWheel(), true).attr(SpinnerBase.PropertyKeys.thousandSeparator.name(), spinner.getThousandSeparator()).attr(SpinnerBase.PropertyKeys.decimalSeparator.name(), spinner.getDecimalSeparator());
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Spinner spinner) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        String styleClass = this.getStyleClassBuilder(context).add(this.createStyleClass((UIInput)spinner, "ui-spinner ui-widget")).add("ui-spinner-" + this.getButtonsClassSuffix(spinner)).build();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (spinner.getStyle() != null) {
            writer.writeAttribute("style", (Object)spinner.getStyle(), null);
        }
        this.encodeInput(context, spinner);
        boolean valid = spinner.isValid();
        String upButtonClass = this.getButtonClass(context, "ui-spinner-button ui-spinner-up ui-button ui-widget ui-state-default ui-button-text-only", spinner.getUpButtonStyleClass(), valid);
        String downButtonClass = this.getButtonClass(context, "ui-spinner-button ui-spinner-down ui-button ui-widget ui-state-default ui-button-text-only", spinner.getDownButtonStyleClass(), valid);
        boolean stacked = "stacked".equals(spinner.getButtons());
        String upIconClass = this.getIconClass(context, spinner.getUpIcon(), stacked ? "ui-icon-triangle-1-n" : "pi pi-plus");
        String downIconClass = this.getIconClass(context, spinner.getDownIcon(), stacked ? "ui-icon-triangle-1-s" : "pi pi-minus");
        this.encodeButton(context, spinner, "increase", upButtonClass, upIconClass);
        this.encodeButton(context, spinner, "decrease", downButtonClass, downIconClass);
        writer.endElement("span");
    }

    protected String getButtonsClassSuffix(Spinner spinner) {
        switch (spinner.getButtons()) {
            case "horizontal": {
                return "horizontal";
            }
            case "horizontal-after": {
                return "horizontal-after";
            }
            case "vertical": {
                return "vertical";
            }
        }
        return "stacked";
    }

    protected String getButtonClass(FacesContext context, String fixedStyleClass, String styleClass, boolean valid) {
        return this.getStyleClassBuilder(context).add(fixedStyleClass).add(styleClass).add(!valid, "ui-state-error").build();
    }

    protected String getIconClass(FacesContext context, String custom, String fallback) {
        return this.getStyleClassBuilder(context).add("ui-icon ui-c").addOrElse(custom, fallback).build();
    }

    protected void encodeInput(FacesContext context, Spinner spinner) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = spinner.getClientId(context) + "_input";
        String inputClass = this.createStyleClass((UIInput)spinner, null, "ui-spinner-input ui-inputfield ui-state-default");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("class", (Object)inputClass, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)spinner);
        if (valueToRender != null) {
            valueToRender = spinner.getPrefix() != null ? spinner.getPrefix() + valueToRender : valueToRender;
            valueToRender = spinner.getSuffix() != null ? valueToRender + spinner.getSuffix() : valueToRender;
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)spinner);
        this.renderPassThruAttributes(context, (UIComponent)spinner, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)spinner, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)spinner, new ClientValidator[0]);
        writer.endElement("input");
    }

    protected void encodeButton(FacesContext context, Spinner spinner, String direction, String styleClass, String iconClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)(spinner.getClientId(context) + "-" + direction), "id");
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (spinner.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)spinner.getTabindex(), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("span");
        writer.endElement("button");
    }

    @Override
    public String getHighlighter() {
        return "spinner";
    }
}

