/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.toolbar;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.toolbar.Toolbar;
import org.primefaces.component.toolbar.ToolbarGroup;
import org.primefaces.model.menu.Separator;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FacetUtils;

public class ToolbarRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Toolbar toolbar = (Toolbar)component;
        if (!this.shouldBeRendered(context, toolbar)) {
            this.encodePlaceholder(context, toolbar);
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String style = toolbar.getStyle();
        Object styleClass = toolbar.getStyleClass();
        styleClass = styleClass == null ? "ui-toolbar ui-widget ui-widget-header" : "ui-toolbar ui-widget ui-widget-header " + (String)styleClass;
        writer.startElement("div", (UIComponent)toolbar);
        writer.writeAttribute("id", (Object)toolbar.getClientId(context), null);
        writer.writeAttribute("class", styleClass, null);
        writer.writeAttribute("role", (Object)"toolbar", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (toolbar.getChildCount() > 0) {
            this.encodeToolbarGroups(context, toolbar);
        } else {
            this.encodeFacet(context, toolbar, "left");
            this.encodeFacet(context, toolbar, "right");
        }
        writer.endElement("div");
    }

    protected void encodeToolbarGroups(FacesContext context, Toolbar toolbar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : toolbar.getChildren()) {
            if (!child.isRendered() || !(child instanceof ToolbarGroup)) continue;
            ToolbarGroup group = (ToolbarGroup)child;
            if (toolbar.getChildCount() == 1 && "right".equals(group.getAlign())) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-toolbar-group-left", null);
                writer.endElement("div");
            }
            String defaultGroupClass = "ui-toolbar-group-" + group.getAlign();
            Object groupClass = group.getStyleClass();
            String groupStyle = group.getStyle();
            groupClass = groupClass == null ? defaultGroupClass : defaultGroupClass + " " + (String)groupClass;
            writer.startElement("div", null);
            writer.writeAttribute("class", groupClass, null);
            if (groupStyle != null) {
                writer.writeAttribute("style", (Object)groupStyle, null);
            }
            for (UIComponent groupChild : group.getChildren()) {
                groupChild.encodeAll(context);
            }
            writer.endElement("div");
        }
    }

    protected void encodeFacet(FacesContext context, Toolbar toolbar, String facetName) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent facet = toolbar.getFacet(facetName);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)("ui-toolbar-group-" + facetName), null);
        if (FacetUtils.shouldRenderFacet(facet)) {
            facet.encodeAll(context);
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected boolean shouldBeRendered(FacesContext facesContext, Toolbar toolbar) {
        if (toolbar.getChildCount() > 0) {
            for (UIComponent child : toolbar.getChildren()) {
                if (!child.isRendered() || !(child instanceof ToolbarGroup)) continue;
                ToolbarGroup toolbarGroup = (ToolbarGroup)child;
                return toolbarGroup.getChildren().stream().anyMatch(c -> this.shouldBeRendered(facesContext, (UIComponent)c));
            }
            return false;
        }
        return FacetUtils.shouldRenderFacet(toolbar.getFacet("left")) || FacetUtils.shouldRenderFacet(toolbar.getFacet("right"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldBeRendered(FacesContext facesContext, UIComponent component) {
        if (component instanceof Separator) {
            return false;
        }
        try {
            component.pushComponentToEL(facesContext, component);
            boolean bl = component.isRendered();
            return bl;
        }
        finally {
            component.popComponentFromEL(facesContext);
        }
    }

    protected void encodePlaceholder(FacesContext context, Toolbar toolbar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)toolbar);
        writer.writeAttribute("id", (Object)toolbar.getClientId(context), "id");
        writer.writeAttribute("class", (Object)"ui-toolbar-placeholder", "styleClass");
        writer.endElement("div");
    }
}

