/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.TreeTableRenderer;
import org.primefaces.component.treetable.feature.TreeTableFeature;
import org.primefaces.model.TreeNode;

public class CellEditFeature
implements TreeTableFeature {
    @Override
    public void encode(FacesContext context, TreeTableRenderer renderer, TreeTable tt) throws IOException {
        TreeNode root = tt.getValue();
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tt.getClientId(context);
        String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
        String rowKey = cellInfo[0];
        int cellIndex = Integer.parseInt(cellInfo[1]);
        int i = -1;
        UIColumn column = null;
        for (UIColumn col : tt.getColumns()) {
            if (!col.isRendered() || ++i != cellIndex) continue;
            column = col;
            break;
        }
        if (column == null) {
            throw new FacesException("No column found for cellIndex: " + cellIndex);
        }
        tt.setRowKey(root, rowKey);
        if (column.isDynamic()) {
            DynamicColumn dynamicColumn = (DynamicColumn)column;
            dynamicColumn.applyStatelessModel();
        }
        if (this.isCellEditCancelRequest(context, clientId) || this.isCellEditInitRequest(context, clientId)) {
            column.getCellEditor().getFacet("input").encodeAll(context);
        } else {
            column.getCellEditor().getFacet("output").encodeAll(context);
        }
        if (column.isDynamic()) {
            ((DynamicColumn)column).cleanStatelessModel();
        }
    }

    @Override
    public boolean shouldDecode(FacesContext context, TreeTable table) {
        return false;
    }

    @Override
    public boolean shouldEncode(FacesContext context, TreeTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_cellInfo");
    }

    private boolean isCellEditCancelRequest(FacesContext context, String clientId) {
        return context.getExternalContext().getRequestParameterMap().containsKey(clientId + "_cellEditCancel");
    }

    private boolean isCellEditInitRequest(FacesContext context, String clientId) {
        return context.getExternalContext().getRequestParameterMap().containsKey(clientId + "_cellEditInit");
    }
}

