/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.metadata.transformer.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.PropertyNotFoundException;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Past;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import org.primefaces.component.api.UICalendar;
import org.primefaces.component.inputnumber.InputNumber;
import org.primefaces.component.spinner.Spinner;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.metadata.BeanValidationMetadataExtractor;
import org.primefaces.metadata.transformer.AbstractInputMetadataTransformer;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

public class BeanValidationInputMetadataTransformer
extends AbstractInputMetadataTransformer {
    private static final Logger LOGGER = Logger.getLogger(BeanValidationInputMetadataTransformer.class.getName());

    @Override
    public void transformInput(FacesContext context, PrimeApplicationContext applicationContext, UIInput input) throws IOException {
        if (ComponentUtils.isDisabledOrReadonly(input) || input.isRequired() && this.isMaxlengthSet(input)) {
            return;
        }
        try {
            Set<ConstraintDescriptor<?>> constraints = BeanValidationMetadataExtractor.extractDefaultConstraintDescriptors(context, applicationContext, input.getValueExpression("value"));
            if (constraints != null && !constraints.isEmpty()) {
                for (ConstraintDescriptor<?> constraintDescriptor : constraints) {
                    this.applyConstraint(constraintDescriptor, input);
                }
            }
        }
        catch (PropertyNotFoundException e) {
            String message = "Skip transform metadata for component \"" + input.getClientId(context) + "\" because the ValueExpression of the \"value\" attribute isn't resolvable completely (e.g. a sub-expression returns null)";
            LOGGER.log(Level.FINE, message);
        }
    }

    protected void applyConstraint(ConstraintDescriptor<?> constraintDescriptor, UIInput input) {
        Min min;
        Max max;
        Size size;
        Annotation constraint = constraintDescriptor.getAnnotation();
        Class<? extends Annotation> annotationType = constraint.annotationType();
        String annotationClassName = annotationType.getSimpleName();
        if (!this.isMaxlengthSet(input) && annotationType.equals(Size.class) && (size = (Size)constraint).max() > 0) {
            this.setMaxlength(input, size.max());
        }
        if (input instanceof Spinner) {
            Spinner spinner = (Spinner)input;
            if (annotationType.equals(Max.class) && spinner.getMax() == Spinner.MAX_VALUE.doubleValue()) {
                max = (Max)constraint;
                spinner.setMax(max.value());
            }
            if (annotationType.equals(Min.class) && spinner.getMin() == Spinner.MIN_VALUE.doubleValue()) {
                min = (Min)constraint;
                spinner.setMin(min.value());
            }
            if (annotationType.equals(DecimalMax.class) && spinner.getMax() == Spinner.MAX_VALUE.doubleValue()) {
                max = (DecimalMax)constraint;
                try {
                    spinner.setMax(Double.parseDouble(max.value()));
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.WARNING, () -> "Failed setting Spinner max value: " + ex.getMessage());
                }
            }
            if (annotationType.equals(DecimalMin.class) && spinner.getMin() == Spinner.MIN_VALUE.doubleValue()) {
                min = (DecimalMin)constraint;
                try {
                    spinner.setMin(Double.parseDouble(min.value()));
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.WARNING, () -> "Failed setting Spinner min value: " + ex.getMessage());
                }
            }
        }
        if (input instanceof InputNumber) {
            InputNumber inputNumber = (InputNumber)input;
            if (LangUtils.isBlank(inputNumber.getMaxValue())) {
                if (annotationType.equals(Max.class)) {
                    max = (Max)constraint;
                    inputNumber.setMaxValue(String.valueOf(max.value()));
                }
                if (annotationType.equals(DecimalMax.class)) {
                    max = (DecimalMax)constraint;
                    inputNumber.setMaxValue(max.value());
                }
                if (annotationClassName.equals("Negative")) {
                    inputNumber.setMaxValue("-0.0000001");
                }
                if (annotationClassName.equals("NegativeOrZero")) {
                    inputNumber.setMaxValue("0");
                }
            }
            if (LangUtils.isBlank(inputNumber.getMinValue())) {
                if (annotationType.equals(Min.class)) {
                    min = (Min)constraint;
                    inputNumber.setMinValue(String.valueOf(min.value()));
                }
                if (annotationType.equals(DecimalMin.class)) {
                    min = (DecimalMin)constraint;
                    inputNumber.setMinValue(min.value());
                }
                if (annotationClassName.equals("Positive")) {
                    inputNumber.setMinValue("0.0000001");
                }
                if (annotationClassName.equals("PositiveOrZero")) {
                    inputNumber.setMinValue("0");
                }
            }
            if (annotationType.equals(Digits.class) && LangUtils.isBlank(inputNumber.getDecimalPlaces())) {
                Digits digits = (Digits)constraint;
                inputNumber.setDecimalPlaces(String.valueOf(digits.fraction()));
            }
        }
        if (input instanceof UICalendar) {
            Class<?> dataType;
            UICalendar uicalendar = (UICalendar)input;
            boolean hasTime = uicalendar.hasTime();
            Temporal now = CalendarUtils.now(uicalendar);
            if (annotationType.equals(Past.class) && uicalendar.getMaxdate() == null) {
                Temporal maxDate = now;
                dataType = uicalendar.getValueType();
                if (dataType != null) {
                    if (LocalDate.class.isAssignableFrom(dataType)) {
                        maxDate = now.minus(1L, ChronoUnit.DAYS);
                    } else if (YearMonth.class.isAssignableFrom(dataType)) {
                        maxDate = now.minus(1L, ChronoUnit.MONTHS);
                    }
                }
                uicalendar.setMaxdate(maxDate);
            }
            if (annotationClassName.equals("PastOrPresent") && uicalendar.getMaxdate() == null) {
                uicalendar.setMaxdate(now);
            }
            if (annotationType.equals(Future.class) && uicalendar.getMindate() == null) {
                Temporal minDate = now;
                if (!hasTime) {
                    dataType = uicalendar.getValueType();
                    minDate = dataType != null && YearMonth.class.isAssignableFrom(dataType) ? now.plus(1L, ChronoUnit.MONTHS) : now.plus(1L, ChronoUnit.DAYS);
                }
                uicalendar.setMindate(minDate);
            }
            if (annotationClassName.equals("FutureOrPresent") && uicalendar.getMindate() == null) {
                uicalendar.setMindate(now);
            }
        }
    }
}

