/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import org.primefaces.model.CheckboxTreeNodeChildren;
import org.primefaces.model.DefaultTreeNode;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeChildren;

public class CheckboxTreeNode<T>
extends DefaultTreeNode<T>
implements TreeNode<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean partialSelected;

    public CheckboxTreeNode() {
    }

    public CheckboxTreeNode(T data) {
        super(data);
    }

    public CheckboxTreeNode(T data, TreeNode parent) {
        super(data, parent);
    }

    public CheckboxTreeNode(String type, T data, TreeNode parent) {
        super(type, data, parent);
    }

    @Override
    protected TreeNodeChildren<T> initChildren() {
        return new CheckboxTreeNodeChildren(this);
    }

    public void setSelected(boolean selected, boolean propagateDown, boolean propagateUp) {
        this.selected = selected;
        this.partialSelected = false;
        if (propagateDown && propagateUp) {
            this.setSelected(selected);
        } else if (!propagateDown && propagateUp) {
            if (this.getParent() != null) {
                ((CheckboxTreeNode)this.getParent()).propagateSelectionUp();
            }
        } else if (propagateDown && !this.isLeaf()) {
            for (TreeNode child : this.children) {
                ((CheckboxTreeNode)child).propagateSelectionDown(selected);
            }
        }
    }

    public void setSelected(boolean selected, boolean propagate) {
        if (propagate) {
            this.setSelected(selected);
        } else {
            this.selected = selected;
        }
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        this.partialSelected = false;
        if (!this.isLeaf()) {
            for (TreeNode child : this.children) {
                ((CheckboxTreeNode)child).propagateSelectionDown(selected);
            }
        }
        if (this.getParent() != null) {
            ((CheckboxTreeNode)this.getParent()).propagateSelectionUp();
        }
    }

    protected void propagateSelectionDown(boolean selected) {
        if (!this.isSelectable()) {
            return;
        }
        this.selected = selected;
        this.partialSelected = false;
        for (TreeNode child : this.children) {
            ((CheckboxTreeNode)child).propagateSelectionDown(selected);
        }
    }

    protected void propagateSelectionUp() {
        if (!this.isSelectable()) {
            return;
        }
        boolean allChildrenSelected = true;
        this.partialSelected = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode childNode = (TreeNode)this.getChildren().get(i);
            boolean childSelected = childNode.isSelected();
            boolean childPartialSelected = childNode.isPartialSelected();
            allChildrenSelected = allChildrenSelected && childSelected;
            this.partialSelected = this.partialSelected || childSelected || childPartialSelected;
        }
        this.selected = allChildrenSelected;
        if (allChildrenSelected) {
            this.setPartialSelected(false);
        }
        if (this.getParent() != null) {
            ((CheckboxTreeNode)this.getParent()).propagateSelectionUp();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.rowKey == null ? 0 : this.rowKey.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CheckboxTreeNode other = (CheckboxTreeNode)obj;
        if (this.data == null ? other.getData() != null : !this.data.equals(other.getData())) {
            return false;
        }
        if (this.rowKey == null) {
            return other.rowKey == null;
        }
        return this.rowKey.equals(other.rowKey);
    }

    @Override
    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    @Override
    public boolean isPartialSelected() {
        return this.partialSelected;
    }

    @Override
    public void setPartialSelected(boolean partialSelected) {
        this.partialSelected = partialSelected;
    }
}

