/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import org.primefaces.model.CheckboxTreeNode;
import org.primefaces.model.DefaultTreeNodeChildren;
import org.primefaces.model.TreeNode;

public class CheckboxTreeNodeChildren<T>
extends DefaultTreeNodeChildren<T> {
    private static final long serialVersionUID = 1L;

    public CheckboxTreeNodeChildren(TreeNode<T> parent) {
        super(parent);
    }

    @Override
    protected void updateRowKeys(TreeNode<?> node) {
        super.updateRowKeys(node);
        this.updateSelectionState(this.parent);
    }

    @Override
    protected void updateRowKeys(int index, TreeNode<?> node) {
        super.updateRowKeys(index, node);
        this.updateSelectionState(this.parent);
    }

    private void updateSelectionState(TreeNode<?> node) {
        boolean allChildrenSelected = true;
        boolean partialSelected = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode childNode = (TreeNode)node.getChildren().get(i);
            boolean childSelected = childNode.isSelected();
            boolean childPartialSelected = childNode.isPartialSelected();
            allChildrenSelected = allChildrenSelected && childSelected;
            partialSelected = partialSelected || childSelected || childPartialSelected;
        }
        ((CheckboxTreeNode)node).setSelected(allChildrenSelected, false);
        if (allChildrenSelected) {
            node.setPartialSelected(false);
        } else {
            node.setPartialSelected(partialSelected);
        }
        TreeNode<?> parentNode = node.getParent();
        if (parentNode != null) {
            this.updateSelectionState(parentNode);
        }
    }
}

