/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.dashboard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.primefaces.model.dashboard.DashboardModel;
import org.primefaces.model.dashboard.DashboardWidget;

public class DefaultDashboardModel
implements DashboardModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<DashboardWidget> widgets = new ArrayList<DashboardWidget>();

    @Override
    public List<DashboardWidget> getWidgets() {
        return this.widgets;
    }

    @Override
    public void addWidget(DashboardWidget widget) {
        this.widgets.add(widget);
    }

    @Override
    public int getWidgetCount() {
        return this.widgets.size();
    }

    @Override
    public DashboardWidget getWidget(int index) {
        return this.widgets.get(index);
    }

    @Override
    public DashboardWidget getWidget(String widgetId) {
        return this.widgets.stream().filter(w -> w.getWidget(0).equalsIgnoreCase(widgetId)).findFirst().orElse(null);
    }

    @Override
    public void transferWidget(DashboardWidget fromWidget, DashboardWidget toWidget, String widgetId, int index, boolean responsive) {
        if (responsive) {
            String fromWidgetId = fromWidget.getWidget(0);
            String toWidgetId = toWidget.getWidget(0);
            String fromCss = fromWidget.getStyleClass();
            String toCss = toWidget.getStyleClass();
            fromWidget.removeWidget(fromWidgetId);
            fromWidget.addWidget(index, toWidgetId);
            toWidget.removeWidget(toWidgetId);
            toWidget.addWidget(index, fromWidgetId);
            fromWidget.setStyleClass(toCss);
            toWidget.setStyleClass(fromCss);
        } else {
            fromWidget.removeWidget(widgetId);
            toWidget.addWidget(index, widgetId);
        }
    }
}

