/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.diagram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.ListDataModel;
import org.primefaces.model.diagram.Connection;
import org.primefaces.model.diagram.DiagramModel;
import org.primefaces.model.diagram.Element;
import org.primefaces.model.diagram.ElementList;
import org.primefaces.model.diagram.connector.Connector;
import org.primefaces.model.diagram.endpoint.EndPoint;
import org.primefaces.model.diagram.overlay.Overlay;

public class DefaultDiagramModel
extends ListDataModel<Element>
implements DiagramModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Connection> connections = new ArrayList<Connection>();
    private Connector defaultConnector;
    private final List<Overlay> defaultConnectionOverlays = new ArrayList<Overlay>();
    private boolean connectionsDetachable = true;
    private int maxConnections = 1;
    private boolean containment = true;

    public DefaultDiagramModel() {
        super((List)new ElementList());
    }

    @Override
    public List<Element> getElements() {
        return (List)this.getWrappedData();
    }

    @Override
    public void addElement(Element element) {
        this.getElements().add(element);
    }

    @Override
    public void removeElement(Element element) {
        this.getElements().remove(element);
    }

    public void clear() {
        this.getElements().clear();
    }

    @Override
    public void clearElements() {
        this.getElements().clear();
    }

    @Override
    public List<Connection> getConnections() {
        return this.connections;
    }

    @Override
    public void connect(Connection connection) {
        this.connections.add(connection);
    }

    @Override
    public void disconnect(Connection connection) {
        this.connections.remove(connection);
    }

    @Override
    public Connector getDefaultConnector() {
        return this.defaultConnector;
    }

    public void setDefaultConnector(Connector defaultConnector) {
        this.defaultConnector = defaultConnector;
    }

    @Override
    public List<Overlay> getDefaultConnectionOverlays() {
        return this.defaultConnectionOverlays;
    }

    @Override
    public boolean isConnectionsDetachable() {
        return this.connectionsDetachable;
    }

    public void setConnectionsDetachable(boolean connectionsDetachable) {
        this.connectionsDetachable = connectionsDetachable;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Override
    public Element findElement(String id) {
        Element element = null;
        List<Element> elements = this.getElements();
        if (elements != null && !elements.isEmpty()) {
            for (int i = 0; i < elements.size(); ++i) {
                Element el = elements.get(i);
                if (!el.getId().equals(id)) continue;
                element = el;
                break;
            }
        }
        return element;
    }

    @Override
    public EndPoint findEndPoint(Element element, String id) {
        EndPoint endPoint = null;
        List<EndPoint> endPoints = element.getEndPoints();
        if (endPoints != null && !endPoints.isEmpty()) {
            for (int i = 0; i < endPoints.size(); ++i) {
                EndPoint ep = endPoints.get(i);
                if (!ep.getId().equals(id)) continue;
                endPoint = ep;
                break;
            }
        }
        return endPoint;
    }

    @Override
    public boolean isContainment() {
        return this.containment;
    }

    public void setContainment(boolean containment) {
        this.containment = containment;
    }
}

