/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.ClientWindow;
import javax.faces.render.Renderer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.clientwindow.PrimeClientWindow;
import org.primefaces.clientwindow.PrimeClientWindowUtils;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MapBuilder;
import org.primefaces.util.ResourceUtils;

public class HeadRenderer
extends Renderer {
    private static final Logger LOGGER = Logger.getLogger(HeadRenderer.class.getName());
    private static final String LIBRARY = "primefaces";
    private static final Map<String, String> THEME_MAPPING = MapBuilder.builder().put("saga", "saga-blue").put("arya", "arya-blue").put("vela", "vela-blue").build();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIComponent middle;
        String theme;
        String themeParamValue;
        ResponseWriter writer = context.getResponseWriter();
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance(context);
        PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
        PrimeConfiguration configuration = applicationContext.getConfig();
        writer.startElement("head", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        UIComponent first = component.getFacet("first");
        if (FacetUtils.shouldRenderFacet(first)) {
            first.encodeAll(context);
        }
        if ((themeParamValue = applicationContext.getConfig().getTheme()) != null) {
            ELContext elContext = context.getELContext();
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression ve = expressionFactory.createValueExpression(elContext, themeParamValue, String.class);
            theme = (String)ve.getValue(elContext);
        } else {
            theme = "saga-blue";
        }
        if (theme != null && !"none".equals(theme)) {
            if (THEME_MAPPING.containsKey(theme)) {
                theme = THEME_MAPPING.get(theme);
            }
            this.encodeCSS(context, "primefaces-" + theme, "theme.css");
        }
        if (applicationContext.getConfig().isPrimeIconsEnabled()) {
            this.encodeCSS(context, LIBRARY, "primeicons/primeicons.css");
        }
        if (FacetUtils.shouldRenderFacet(middle = component.getFacet("middle"))) {
            middle.encodeAll(context);
        }
        this.encodeValidationResources(context, configuration);
        this.encodeLocaleResources(context, configuration);
        UIViewRoot viewRoot = context.getViewRoot();
        ArrayList<UIComponent> resources = new ArrayList<UIComponent>(viewRoot.getComponentResources(context, "head"));
        this.moveResourceToTop(resources, "primeicons/primeicons.css");
        this.moveResourceToTop(resources, "theme.css");
        for (int i = 0; i < resources.size(); ++i) {
            UIComponent resource = (UIComponent)resources.get(i);
            LOGGER.log(Level.FINE, () -> "HeadRenderer resource: " + String.valueOf(resource.getAttributes().get("name")));
            resource.encodeAll(context);
        }
        this.encodeSettingScripts(context, requestContext, configuration, writer);
        this.encodeInitScripts(context, requestContext, configuration, writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent last = component.getFacet("last");
        if (FacetUtils.shouldRenderFacet(last)) {
            last.encodeAll(context);
        }
        writer.endElement("head");
    }

    protected void encodeCSS(FacesContext context, String library, String resource) throws IOException {
        ResourceUtils.addStyleSheetResource(context, library, resource);
    }

    protected void encodeJS(FacesContext context, String library, String script) throws IOException {
        ResourceUtils.addJavascriptResource(context, library, script);
    }

    protected void encodeValidationResources(FacesContext context, PrimeConfiguration configuration) {
        if (configuration.isClientSideValidationEnabled()) {
            ResourceUtils.addJavascriptResource(context, "moment/moment.js");
            if (configuration.isBeanValidationEnabled()) {
                ResourceUtils.addJavascriptResource(context, "validation/validation.bv.js");
            }
        }
    }

    protected void encodeLocaleResources(FacesContext context, PrimeConfiguration configuration) {
        block3: {
            if (!configuration.isClientSideLocalizationEnabled()) {
                return;
            }
            try {
                Locale locale = LocaleUtils.getCurrentLocale(context);
                ResourceUtils.addJavascriptResource(context, "locales/locale-" + locale.getLanguage() + ".js");
            }
            catch (FacesException e) {
                if (!context.isProjectStage(ProjectStage.Development)) break block3;
                LOGGER.log(Level.WARNING, "Failed to load client side locale.js. {0}", e.getMessage());
            }
        }
    }

    protected void encodeSettingScripts(FacesContext context, PrimeRequestContext requestContext, PrimeConfiguration configuration, ResponseWriter writer) throws IOException {
        ClientWindow clientWindow;
        ProjectStage projectStage = context.getApplication().getProjectStage();
        ExternalContext externalContext = context.getExternalContext();
        writer.startElement("script", null);
        RendererUtils.encodeScriptTypeIfNecessary(context);
        writer.write("if(window.PrimeFaces){");
        writer.write("PrimeFaces.settings={");
        writer.write("locale:'" + String.valueOf(LocaleUtils.getCurrentLocale(context)) + "',");
        writer.write("viewId:'" + context.getViewRoot().getViewId() + "',");
        writer.write("contextPath:'" + externalContext.getRequestContextPath() + "',");
        writer.write("cookiesSecure:" + (requestContext.isSecure() && configuration.isCookiesSecure()));
        if (configuration.getCookiesSameSite() != null) {
            writer.write(",cookiesSameSite:'" + configuration.getCookiesSameSite() + "'");
        }
        writer.write(",validateEmptyFields:" + configuration.isValidateEmptyFields());
        writer.write(",considerEmptyStringNull:" + configuration.isInterpretEmptyStringAsNull());
        if (configuration.isEarlyPostParamEvaluation()) {
            writer.write(",earlyPostParamEvaluation:true");
        }
        if (configuration.isPartialSubmitEnabled()) {
            writer.write(",partialSubmit:true");
        }
        if (projectStage != ProjectStage.Production) {
            writer.write(",projectStage:'" + projectStage.toString() + "'");
        }
        writer.write("};");
        if (externalContext.getClientWindow() != null && (clientWindow = externalContext.getClientWindow()) instanceof PrimeClientWindow) {
            boolean initialRedirect = false;
            Object cookie = PrimeClientWindowUtils.getInitialRedirectCookie(context, clientWindow.getId());
            if (cookie instanceof Cookie) {
                Cookie servletCookie = (Cookie)cookie;
                initialRedirect = true;
                servletCookie.setMaxAge(0);
                ((HttpServletResponse)externalContext.getResponse()).addCookie(servletCookie);
            }
            writer.write(String.format("PrimeFaces.clientwindow.init('%s', %s);", PrimeClientWindowUtils.secureWindowId(clientWindow.getId()), initialRedirect));
        }
        writer.write("}");
        writer.endElement("script");
    }

    protected void encodeInitScripts(FacesContext context, PrimeRequestContext requestContext, PrimeConfiguration configuration, ResponseWriter writer) throws IOException {
        List<String> scripts = requestContext.getInitScriptsToExecute();
        if (scripts.isEmpty()) {
            return;
        }
        writer.startElement("script", null);
        RendererUtils.encodeScriptTypeIfNecessary(context);
        boolean moveScriptsToBottom = configuration.isMoveScriptsToBottom();
        if (!moveScriptsToBottom) {
            writer.write("(function(){const pfInit=()=>{");
            writer.write(String.join((CharSequence)";", scripts));
            writer.write("};if(window.$)$(pfInit);");
            writer.write("else if(document.readyState==='complete')pfInit();");
            writer.write("else document.addEventListener('DOMContentLoaded',pfInit)})();");
        } else {
            writer.write(String.join((CharSequence)";", scripts));
            writer.write(59);
        }
        writer.endElement("script");
    }

    protected void moveResourceToTop(List<UIComponent> resources, String resource) {
        resources.sort((a, b) -> {
            String nameA = (String)a.getAttributes().get("name");
            String nameB = (String)b.getAttributes().get("name");
            if (nameA != null && nameA.endsWith(resource)) {
                return -1;
            }
            if (nameB != null && nameB.endsWith(resource)) {
                return 1;
            }
            return 0;
        });
    }
}

