/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.shaded.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.primefaces.shaded.owasp.encoder.Encoder;
import org.primefaces.shaded.owasp.encoder.Unicode;

class CDATAEncoder
extends Encoder {
    private static final char[] CDATA_END_ENCODED = "]]]]><![CDATA[>".toCharArray();
    private static final int CDATA_END_ENCODED_LENGTH = 15;
    private static final int CDATA_END_LENGTH = 3;

    CDATAEncoder() {
    }

    @Override
    protected int maxEncodedLength(int n) {
        int worstCase = n / 3;
        int remainder = n % 3;
        return worstCase * 15 + remainder;
    }

    @Override
    protected int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        for (int i = off; i < n; ++i) {
            char ch = input.charAt(i);
            if (ch <= '~') {
                if (ch != ']') {
                    if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
                    return i;
                }
                if (i + 1 < n) {
                    if (input.charAt(i + 1) != ']') continue;
                    while (i + 2 < n && input.charAt(i + 2) == ']') {
                        ++i;
                    }
                    if (i + 2 < n) {
                        if (input.charAt(i + 2) != '>') continue;
                        return i;
                    }
                    return n;
                }
                return n;
            }
            if (ch < '\ud800') {
                if (ch > '\u009f' || ch == '\u0085') continue;
                return i;
            }
            if (ch <= '\udbff') {
                if (i + 1 < n) {
                    if (Character.isLowSurrogate(input.charAt(i + 1))) {
                        int cp = Character.toCodePoint(ch, input.charAt(i + 1));
                        if (Unicode.isNonCharacter(cp)) {
                            return i;
                        }
                        ++i;
                        continue;
                    }
                    return i;
                }
                return i;
            }
            if (ch > '\udfff' && ch <= '\ufffd' && ('\ufdd0' > ch || ch > '\ufdef')) continue;
            return i;
        }
        return n;
    }

    @Override
    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i;
        char[] in = input.array();
        char[] out = output.array();
        int n = input.arrayOffset() + input.limit();
        int j = output.arrayOffset() + output.position();
        int m = output.arrayOffset() + output.limit();
        for (i = input.arrayOffset() + input.position(); i < n; ++i) {
            char ch = in[i];
            if (ch <= '~') {
                if (ch != ']') {
                    if (j >= m) {
                        return CDATAEncoder.overflow(input, i, output, j);
                    }
                    if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') {
                        out[j++] = ch;
                        continue;
                    }
                    out[j++] = 32;
                    continue;
                }
                if (i + 1 < n) {
                    if (in[i + 1] != ']') {
                        if (j >= m) {
                            return CDATAEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 93;
                        continue;
                    }
                    while (i + 2 < n && in[i + 2] == ']') {
                        if (j >= m) {
                            return CDATAEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 93;
                        ++i;
                    }
                    if (i + 2 < n) {
                        if (in[i + 2] == '>') {
                            if (j + 15 > m) {
                                return CDATAEncoder.overflow(input, i, output, j);
                            }
                            System.arraycopy(CDATA_END_ENCODED, 0, out, j, 15);
                            j += 15;
                            i += 2;
                            continue;
                        }
                        if (j >= m) {
                            return CDATAEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 93;
                        continue;
                    }
                    if (!endOfInput) break;
                    if (j + 2 > m) {
                        return CDATAEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 93;
                    out[j++] = 93;
                    i = n;
                    break;
                }
                if (!endOfInput) break;
                if (j >= m) {
                    return CDATAEncoder.overflow(input, i, output, j);
                }
                out[j++] = 93;
                ++i;
                break;
            }
            if (ch < '\ud800') {
                if (ch > '\u009f' || ch == '\u0085') {
                    if (j >= m) {
                        return CDATAEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch;
                    continue;
                }
                if (j >= m) {
                    return CDATAEncoder.overflow(input, i, output, j);
                }
                out[j++] = 32;
                continue;
            }
            if (ch <= '\udbff') {
                if (i + 1 < n) {
                    if (Character.isLowSurrogate(in[i + 1])) {
                        int cp = Character.toCodePoint(ch, in[i + 1]);
                        if (Unicode.isNonCharacter(cp)) {
                            if (j >= m) {
                                return CDATAEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 32;
                            ++i;
                            continue;
                        }
                        if (j + 1 >= m) {
                            return CDATAEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = ch;
                        out[j++] = in[++i];
                        continue;
                    }
                    if (j >= m) {
                        return CDATAEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 32;
                    continue;
                }
                if (!endOfInput) break;
                if (j >= m) {
                    return CDATAEncoder.overflow(input, i, output, j);
                }
                out[j++] = 32;
                continue;
            }
            if (ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                if (j >= m) {
                    return CDATAEncoder.overflow(input, i, output, j);
                }
                out[j++] = 32;
                continue;
            }
            if (j >= m) {
                return CDATAEncoder.overflow(input, i, output, j);
            }
            out[j++] = ch;
        }
        return CDATAEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "CDATAEncoder";
    }
}

