/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import javax.faces.context.FacesContext;

public class AgentUtils {
    private AgentUtils() {
    }

    private static String getUserAgent(FacesContext context) {
        return (String)context.getExternalContext().getRequestHeaderMap().get("User-Agent");
    }

    private static boolean userAgentContains(FacesContext context, String fragment) {
        String userAgent = AgentUtils.getUserAgent(context);
        if (userAgent == null) {
            return false;
        }
        return userAgent.contains(fragment);
    }

    public static boolean isFirefox(FacesContext context) {
        return AgentUtils.userAgentContains(context, "Firefox");
    }

    public static boolean isMac(FacesContext context) {
        return AgentUtils.userAgentContains(context, "Mac");
    }
}

